/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json;

import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FormatVersion<T extends FormatVersion<T>> {
    @NotNull
    private final String serializedName;
    private final boolean supported;
    @Nullable
    private final String errorMessage;

    protected FormatVersion(@NotNull String pSerializedName, boolean pSupported, @Nullable String pErrorMessage) {
        this.serializedName = pSerializedName;
        this.supported = pSupported;
        this.errorMessage = pErrorMessage;
    }

    @NotNull
    public String getSerializedName() {
        return this.serializedName;
    }

    public boolean isSupported() {
        return this.supported;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @NotNull
    protected static <T extends FormatVersion<T>> T register(@NotNull Map<String, T> pRegistry, @NotNull T pVersion) {
        pRegistry.put(pVersion.getSerializedName(), pVersion);
        return pVersion;
    }

    public static interface Registry<T extends FormatVersion<T>> {
        @NotNull
        public Map<String, T> versions();

        @NotNull
        public T defaultVersion();

        @NotNull
        default public T get(@NotNull String pName) {
            return (T)((FormatVersion)this.versions().getOrDefault(pName, this.defaultVersion()));
        }

        default public void register(@NotNull T pVersion) {
            this.versions().put(((FormatVersion)pVersion).getSerializedName(), pVersion);
        }

        @NotNull
        default public Map<String, T> getRegisteredVersions() {
            return Collections.unmodifiableMap(this.versions());
        }

        @NotNull
        default public T match(@NotNull String pVersion) {
            return this.get(pVersion);
        }
    }
}

