/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.controller;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import software.bluelib.loader.cache.controller.AnimationCache;
import software.bluelib.loader.cache.controller.BehaviourCache;
import software.bluelib.loader.cache.controller.ControllerCache;
import software.bluelib.loader.cache.controller.GroupCache;
import software.bluelib.loader.cache.controller.StateCache;
import software.bluelib.loader.json.CacheFactory;
import software.bluelib.loader.json.deserialize.controller.Animation;
import software.bluelib.loader.json.deserialize.controller.Behaviour;
import software.bluelib.loader.json.deserialize.controller.Controller;
import software.bluelib.loader.json.deserialize.controller.Group;
import software.bluelib.loader.json.deserialize.controller.State;

public interface ControllerCacheFactory
extends CacheFactory<ControllerCache, Controller> {
    @NotNull
    public static final Map<String, ControllerCacheFactory> FACTORIES = new Object2ObjectOpenHashMap(1);
    @NotNull
    public static final ControllerCacheFactory DEFAULT_FACTORY = new Builtin();
    @NotNull
    public static final CacheFactory.Registry<ControllerCache, Controller, ControllerCacheFactory> REGISTRY = new CacheFactory.Registry<ControllerCache, Controller, ControllerCacheFactory>(){

        @Override
        @NotNull
        public Map<String, ControllerCacheFactory> factories() {
            return FACTORIES;
        }

        @Override
        @NotNull
        public ControllerCacheFactory defaultFactory() {
            return DEFAULT_FACTORY;
        }
    };

    @Override
    @NotNull
    default public ControllerCache construct(@NotNull Controller pSource) {
        return this.constructBlueController(pSource);
    }

    @NotNull
    public ControllerCache constructBlueController(@NotNull Controller var1);

    public static final class Builtin
    implements ControllerCacheFactory {
        @Override
        @NotNull
        public ControllerCache constructBlueController(@NotNull Controller pController) {
            List<GroupCache> groupCaches = this.constructGroupCaches(pController.groups());
            return new ControllerCache(pController.formatVersion(), groupCaches);
        }

        @NotNull
        private List<GroupCache> constructGroupCaches(@NotNull List<Group> pGroups) {
            return pGroups.stream().map(this::constructGroupCache).toList();
        }

        @NotNull
        private GroupCache constructGroupCache(@NotNull Group pGroup) {
            Map<String, BehaviourCache> behaviourCaches = this.constructBehaviourCaches(pGroup.behaviours());
            return new GroupCache(behaviourCaches);
        }

        @NotNull
        private Map<String, BehaviourCache> constructBehaviourCaches(@NotNull Map<String, Behaviour> pBehaviours) {
            Object2ObjectOpenHashMap behaviourCaches = new Object2ObjectOpenHashMap(pBehaviours.size());
            for (Map.Entry<String, Behaviour> entry : pBehaviours.entrySet()) {
                String name = entry.getKey();
                Behaviour behaviour = entry.getValue();
                Map<String, StateCache> stateCache = this.constructStateCaches(behaviour.states());
                BehaviourCache behaviourCache = new BehaviourCache(behaviour.conditions(), behaviour.priority(), stateCache);
                behaviourCaches.put(name, behaviourCache);
            }
            return behaviourCaches;
        }

        @NotNull
        private Map<String, StateCache> constructStateCaches(@NotNull Map<String, State> pStates) {
            Object2ObjectOpenHashMap stateCaches = new Object2ObjectOpenHashMap(pStates.size());
            for (Map.Entry<String, State> entry : pStates.entrySet()) {
                String name = entry.getKey();
                State state = entry.getValue();
                StateCache stateCache = this.constructStateCache(state);
                stateCaches.put(name, stateCache);
            }
            return stateCaches;
        }

        @NotNull
        private StateCache constructStateCache(@NotNull State pState) {
            List<AnimationCache> animationCaches = this.constructAnimationsCaches(pState.animations());
            return new StateCache(pState.isOverlay(), animationCaches);
        }

        @NotNull
        private List<AnimationCache> constructAnimationsCaches(@NotNull List<Animation> pAnimations) {
            return pAnimations.stream().map(this::constructAnimationCache).toList();
        }

        @NotNull
        private AnimationCache constructAnimationCache(@NotNull Animation pAnimation) {
            return new AnimationCache(pAnimation.conditions(), pAnimation.animation(), pAnimation.priority(), pAnimation.sound());
        }
    }
}

