/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.deserialize.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.loader.JsonUtils;

public record PolysUnion(@NotNull List<List<List<Float>>> union, @Nullable Type type) {
    @NotNull
    public static JsonDeserializer<PolysUnion> deserializer() throws JsonParseException {
        return (json, type, context) -> PolysUnion.fromJson(json, context);
    }

    @NotNull
    public static PolysUnion fromJson(@NotNull JsonElement pJson, @NotNull JsonDeserializationContext pContext) throws JsonParseException {
        if (pJson.isJsonPrimitive() && pJson.getAsJsonPrimitive().isString()) {
            Type type = (Type)((Object)pContext.deserialize((JsonElement)pJson.getAsJsonPrimitive(), Type.class));
            return new PolysUnion(new ArrayList<List<List<Float>>>(), type);
        }
        if (pJson.isJsonArray()) {
            ArrayList<List<List<Float>>> matrix = new ArrayList<List<List<Float>>>();
            for (JsonElement xElem : pJson.getAsJsonArray()) {
                ArrayList<List<Float>> yList = new ArrayList<List<Float>>();
                for (JsonElement yElem : xElem.getAsJsonArray()) {
                    List<Float> zList = JsonUtils.jsonArrayToFloatList(yElem.getAsJsonArray());
                    yList.add(zList);
                }
                matrix.add(yList);
            }
            return new PolysUnion(matrix, null);
        }
        throw new JsonParseException("Invalid format for PolysUnion, must be either string or array");
    }

    public static enum Type {
        QUAD,
        TRI;

    }
}

