/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.deserialize.variants;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import software.bluelib.loader.json.deserialize.variants.Variant;

public record Entity(@NotNull String formatVersion, @NotNull Map<String, Variant> variants) {
    @NotNull
    public static JsonDeserializer<Entity> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            String formatVersion = GsonHelper.getAsString((JsonObject)obj, (String)"format_version", (String)"1.0.0");
            HashMap<String, Variant> variants = new HashMap<String, Variant>();
            for (String variantName : obj.keySet()) {
                variants.put(variantName, (Variant)context.deserialize(obj.get(variantName), Variant.class));
            }
            return new Entity(formatVersion, variants);
        };
    }
}

