/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.object;

import java.util.List;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import software.bluelib.loader.json.deserialize.model.FaceUV;
import software.bluelib.loader.json.object.VertexData;

public record QuadData(@NotNull List<VertexData> vertices, @NotNull Vector3f normal, @NotNull Direction direction) {
    @NotNull
    public static QuadData build(@NotNull List<VertexData> pVertices, @NotNull List<Float> pUvCoords, @NotNull List<Float> pUvSize, @NotNull FaceUV.Rotation pUvRotation, @NotNull Float pTextureWidth, @NotNull Float pTextureHeight, boolean pMirror, @NotNull Direction pDirection) {
        return QuadData.build(pVertices, pUvCoords.get(0), pUvCoords.get(1), pUvSize.get(0), pUvSize.get(1), pUvRotation, pTextureWidth, pTextureHeight, pMirror, pDirection);
    }

    @NotNull
    public static QuadData build(@NotNull List<VertexData> pVertices, @NotNull Float pU, @NotNull Float pV, @NotNull Float pUSize, @NotNull Float pVSize, @NotNull FaceUV.Rotation pUvRotation, @NotNull Float pTextureWidth, @NotNull Float pTextureHeight, boolean pMirror, @NotNull Direction pDirection) {
        float uWidth = (pU.floatValue() + pUSize.floatValue()) / pTextureWidth.floatValue();
        float vHeight = (pV.floatValue() + pVSize.floatValue()) / pTextureHeight.floatValue();
        pU = Float.valueOf(pU.floatValue() / pTextureWidth.floatValue());
        pV = Float.valueOf(pV.floatValue() / pTextureHeight.floatValue());
        Vector3f normal = pDirection.step();
        if (!pMirror) {
            float tempWidth = uWidth;
            uWidth = pU.floatValue();
            pU = Float.valueOf(tempWidth);
        } else {
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        List<Float> uvs = pUvRotation.rotateUvs(pU, pV, Float.valueOf(uWidth), Float.valueOf(vHeight));
        pVertices.set(0, pVertices.get(0).withUVs(uvs.get(0), uvs.get(1)));
        pVertices.set(1, pVertices.get(1).withUVs(uvs.get(2), uvs.get(3)));
        pVertices.set(2, pVertices.get(2).withUVs(uvs.get(4), uvs.get(5)));
        pVertices.set(3, pVertices.get(3).withUVs(uvs.get(6), uvs.get(7)));
        return new QuadData(pVertices, normal, pDirection);
    }
}

