/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.variants;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import software.bluelib.loader.cache.variants.EntityCache;
import software.bluelib.loader.cache.variants.VariantCache;
import software.bluelib.loader.json.CacheFactory;
import software.bluelib.loader.json.deserialize.variants.Entity;
import software.bluelib.loader.json.deserialize.variants.Variant;

public interface VariantsCacheFactory
extends CacheFactory<EntityCache, Entity> {
    @NotNull
    public static final Map<String, VariantsCacheFactory> FACTORIES = new Object2ObjectOpenHashMap(1);
    @NotNull
    public static final VariantsCacheFactory DEFAULT_FACTORY = new Builtin();
    @NotNull
    public static final CacheFactory.Registry<EntityCache, Entity, VariantsCacheFactory> REGISTRY = new CacheFactory.Registry<EntityCache, Entity, VariantsCacheFactory>(){

        @Override
        @NotNull
        public Map<String, VariantsCacheFactory> factories() {
            return FACTORIES;
        }

        @Override
        @NotNull
        public VariantsCacheFactory defaultFactory() {
            return DEFAULT_FACTORY;
        }
    };

    @Override
    @NotNull
    default public EntityCache construct(@NotNull Entity pSource) {
        return this.constructVariants(pSource);
    }

    @NotNull
    public EntityCache constructVariants(@NotNull Entity var1);

    public static final class Builtin
    implements VariantsCacheFactory {
        @Override
        @NotNull
        public EntityCache constructVariants(@NotNull Entity pVariants) {
            Object2ObjectOpenHashMap variantCaches = new Object2ObjectOpenHashMap();
            for (Map.Entry<String, Variant> entry : pVariants.variants().entrySet()) {
                variantCaches.put(entry.getKey(), this.constructVariantCache(entry.getValue()));
            }
            return new EntityCache(pVariants.formatVersion(), (Map<String, VariantCache>)variantCaches);
        }

        @NotNull
        private VariantCache constructVariantCache(@NotNull Variant pVariant) {
            return new VariantCache(pVariant.parameters());
        }
    }
}

