/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.base;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderer;

public class BlueRenderLayersContainer<T extends BlueAnimatable> {
    @NotNull
    private final BlueRenderer<T> renderer;
    @NotNull
    private final List<BlueRenderLayer<T>> layers = new ObjectArrayList();
    private boolean compiledLayers = false;

    public BlueRenderLayersContainer(@NotNull BlueRenderer<T> pRenderer) {
        this.renderer = pRenderer;
    }

    @NotNull
    public List<BlueRenderLayer<T>> getRenderLayers() {
        if (!this.compiledLayers) {
            this.fireCompileRenderLayersEvent();
        }
        return this.layers;
    }

    public void addLayer(@NotNull BlueRenderLayer<T> pLayer) {
        this.layers.add(pLayer);
    }

    public void fireCompileRenderLayersEvent() {
        this.compiledLayers = true;
        this.renderer.fireCompileRenderLayersEvent();
    }
}

