/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.base;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bluelib.api.exception.nulls.AnimatableNullException;
import software.bluelib.api.utils.Color;
import software.bluelib.api.utils.loader.BufferUtils;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.model.CubeCache;
import software.bluelib.loader.geckolib.math.MoLangQueries;
import software.bluelib.loader.json.object.QuadData;
import software.bluelib.loader.json.object.VertexData;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;

public interface BlueRenderer<T extends BlueAnimatable> {
    @NotNull
    public BlueModel<T> getBlueModel();

    @Nullable
    public T getOptionalAnimatable();

    @NotNull
    default public T getAnimatable() {
        T animatable = this.getOptionalAnimatable();
        if (animatable == null) {
            throw new AnimatableNullException("Animatable cannot be null when rendering!");
        }
        return animatable;
    }

    @NotNull
    default public ResourceLocation getTextureLocation(@NotNull T pAnimatable) {
        return this.getBlueModel().getTextureResource(pAnimatable, this);
    }

    @NotNull
    default public List<BlueRenderLayer<T>> getRenderLayers() {
        return List.of();
    }

    @Nullable
    default public RenderType getRenderType(@NotNull ResourceLocation pTexture, @NotNull IRenderContext<T> pContext) {
        return this.getBlueModel().getRenderType(pContext.animatable(), pTexture);
    }

    @NotNull
    default public Color getRenderColor(@NotNull T pAnimatable, float pPartialTick, int pPackedLight) {
        return Color.WHITE;
    }

    default public int getPackedOverlay(@NotNull T pAnimatable, float pU, float pPartialTick) {
        return OverlayTexture.NO_OVERLAY;
    }

    default public long getInstanceId(@NotNull IRenderContext<T> pContext) {
        return pContext.animatable().hashCode();
    }

    default public float getMotionAnimThreshold(@NotNull IRenderContext<T> pContext) {
        return 0.015f;
    }

    public static <M extends BlueAnimatable> void handleBaseRenderContext(@NotNull BaseRenderContext<M> pContext, @NotNull BlueRenderer<M> pRenderer, @NotNull BiConsumer<BlueRenderer<M>, FullRenderContext<M>> pRenderMethod) {
        VertexConsumer buffer;
        RenderType type = pRenderer.getRenderType(pRenderer.getTextureLocation(pContext.animatable()), pContext);
        VertexConsumer vertexConsumer = buffer = type != null ? pContext.bufferSource().getBuffer(type) : null;
        if (type == null) {
            pContext.poseStack().popPose();
            return;
        }
        FullRenderContext<M> full = new FullRenderContext<M>(pContext.poseStack(), pContext.animatable(), pContext.model(), type, pContext.bufferSource(), buffer, pContext.isReRender(), pContext.partialTick(), pContext.packedLight(), pContext.packedOverlay(), pContext.color());
        pRenderMethod.accept(pRenderer, full);
        pContext.poseStack().popPose();
    }

    default public void defaultRender(@NotNull IRenderContext<T> pContext) {
        pContext.poseStack().pushPose();
        if (pContext instanceof FullRenderContext) {
            FullRenderContext full = (FullRenderContext)pContext;
            this.preRender(full);
            if (this.firePreRenderEvent(full)) {
                this.preApplyRenderLayers(full);
                this.actuallyRender(full);
                this.applyRenderLayers(full);
                this.postRender(full);
                this.firePostRenderEvent(full);
            }
            full.poseStack().popPose();
            this.renderFinal(full);
            this.doPostRenderCleanup(full);
            MoLangQueries.clearActor();
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            this.handleBaseDefaultRenderContext(base, this);
        }
    }

    @ApiStatus.NonExtendable
    default public <M extends BlueAnimatable> void handleBaseDefaultRenderContext(@NotNull BaseRenderContext<M> pContext, @NotNull BlueRenderer<M> pRenderer) {
        BlueRenderer.handleBaseRenderContext(pContext, pRenderer, BlueRenderer::defaultRender);
    }

    default public void reRender(@NotNull IRenderContext<T> pContext) {
        pContext.poseStack().pushPose();
        this.preRender(pContext);
        this.actuallyRender(pContext);
        this.postRender(pContext);
        pContext.poseStack().popPose();
    }

    default public void actuallyRender(@NotNull IRenderContext<T> pContext) {
        if (pContext instanceof FullRenderContext) {
            FullRenderContext full = (FullRenderContext)pContext;
            if (full.optionalBuffer() == null) {
                if (full.optionalRenderType() == null) {
                    return;
                }
                VertexConsumer buffer = full.bufferSource().getBuffer(full.renderType());
                full = new FullRenderContext(full.poseStack(), full.animatable(), full.model(), full.renderType(), full.bufferSource(), buffer, full.isReRender(), full.partialTick(), full.packedLight(), full.packedOverlay(), full.color());
            }
            this.updateAnimatedTextureFrame(full);
            for (BoneCache group : full.model().topLevelBones()) {
                this.renderRecursively(group, full);
            }
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            this.handleBaseActuallyRenderContext(base, this);
        }
    }

    @ApiStatus.NonExtendable
    default public <M extends BlueAnimatable> void handleBaseActuallyRenderContext(@NotNull BaseRenderContext<M> pContext, @NotNull BlueRenderer<M> pRenderer) {
        BlueRenderer.handleBaseRenderContext(pContext, pRenderer, BlueRenderer::actuallyRender);
    }

    default public void preApplyRenderLayers(@NotNull IRenderContext<T> pContext) {
        for (BlueRenderLayer<T> renderLayer : this.getRenderLayers()) {
            renderLayer.preRender(pContext);
        }
    }

    default public void applyRenderLayersForBone(@NotNull BoneCache pBone, @NotNull IRenderContext<T> pContext) {
        for (BlueRenderLayer<T> renderLayer : this.getRenderLayers()) {
            renderLayer.renderForBone(pBone, pContext);
        }
    }

    default public void applyRenderLayers(@NotNull IRenderContext<T> pContext) {
        for (BlueRenderLayer<T> renderLayer : this.getRenderLayers()) {
            renderLayer.render(pContext);
        }
    }

    default public void preRender(@NotNull IRenderContext<T> pContext) {
    }

    default public void postRender(@NotNull IRenderContext<T> pContext) {
    }

    default public void renderFinal(@NotNull IRenderContext<T> pContext) {
    }

    default public void doPostRenderCleanup(@NotNull IRenderContext<T> pContext) {
    }

    default public void renderRecursively(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        pContext.poseStack().pushPose();
        RenderUtils.prepMatrixForBone(pContext.poseStack(), pBone);
        pContext.setBuffer(BufferUtils.checkAndRefreshBuffer(pContext.isReRender(), pContext.buffer(), pContext.bufferSource(), pContext.renderType()));
        this.renderCubesOfBone(pBone, pContext);
        if (!pContext.isReRender()) {
            this.applyRenderLayersForBone(pBone, pContext);
        }
        this.renderChildBones(pBone, pContext);
        pContext.poseStack().popPose();
    }

    default public void renderCubesOfBone(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        if (pBone.isHidden()) {
            return;
        }
        for (CubeCache cube : pBone.getCubes()) {
            pContext.poseStack().pushPose();
            this.renderCube(cube, pContext);
            pContext.poseStack().popPose();
        }
    }

    default public void renderChildBones(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        if (pBone.isHidingChildren()) {
            return;
        }
        for (BoneCache childBone : pBone.getChildBones()) {
            this.renderRecursively(childBone, pContext);
        }
    }

    default public void renderCube(@NotNull CubeCache pCube, @NotNull FullRenderContext<T> pContext) {
        RenderUtils.translateToPivotPoint(pContext.poseStack(), pCube);
        RenderUtils.rotateMatrixAroundCube(pContext.poseStack(), pCube);
        RenderUtils.translateAwayFromPivotPoint(pContext.poseStack(), pCube);
        Matrix3f normalisedPoseState = pContext.poseStack().last().normal();
        Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
        for (QuadData quad : pCube.quads()) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(new Vector3f((Vector3fc)quad.normal()));
            RenderUtils.fixInvertedFlatCube(pCube, normal);
            this.createVerticesOfQuad(quad, poseState, normal, pContext);
        }
    }

    default public void createVerticesOfQuad(@NotNull QuadData pQuad, @NotNull Matrix4f pPoseState, @NotNull Vector3f pNormal, @NotNull FullRenderContext<T> pContext) {
        for (VertexData vertex : pQuad.vertices()) {
            Vector3f position = vertex.position();
            Vector4f vector4f = pPoseState.transform(new Vector4f(position.x(), position.y(), position.z(), 1.0f));
            pContext.buffer().addVertex(vector4f.x(), vector4f.y(), vector4f.z(), pContext.color(), vertex.texU().floatValue(), vertex.texV().floatValue(), pContext.packedOverlay(), pContext.packedLight(), pNormal.x(), pNormal.y(), pNormal.z());
        }
    }

    public void fireCompileRenderLayersEvent();

    public boolean firePreRenderEvent(@NotNull IRenderContext<T> var1);

    public void firePostRenderEvent(@NotNull IRenderContext<T> var1);

    default public void scaleModelForRender(float pWidthScale, float pHeightScale, @NotNull IRenderContext<T> pContext) {
        if (!(pContext.isReRender() || pWidthScale == 1.0f && pHeightScale == 1.0f)) {
            pContext.poseStack().scale(pWidthScale, pHeightScale, pWidthScale);
        }
    }

    public void updateAnimatedTextureFrame(@NotNull IRenderContext<T> var1);
}

