/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.markdown;

import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.QuadConsumer;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;

public abstract class MarkdownFeature {
    @Nullable
    protected String prefix;
    @Nullable
    protected String suffix;

    @NotNull
    public MutableComponent apply(@NotNull MutableComponent pComponent) {
        if (!this.isFeatureEnabled().booleanValue()) {
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.log("markdown.feature.disabled", this.getFeatureName()));
            return pComponent;
        }
        if (this.prefix == null || this.suffix == null) {
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("markdown.feature.prefix_suffix_not_set", this.getFeatureName()));
            return pComponent;
        }
        Pattern pattern = Pattern.compile(Pattern.quote(this.prefix) + "(.*?)" + Pattern.quote(this.suffix));
        MutableComponent result = Component.empty();
        if (pComponent.getSiblings().isEmpty()) {
            this.processComponentTextWithFormatting(pComponent.getString(), pComponent.getStyle(), result, pattern);
        } else {
            result = this.processSiblingsWithFormatting(pComponent, pattern);
        }
        return result;
    }

    protected void processComponentText(@NotNull String pText, @NotNull Style pOriginalStyle, @NotNull MutableComponent pResult, @NotNull Pattern pPattern, @NotNull BiConsumer<Matcher, MutableComponent> pSpecialTextHandler) {
        Matcher matcher = pPattern.matcher(pText);
        int lastIndex = 0;
        while (matcher.find()) {
            if (matcher.group(1).isEmpty()) {
                this.appendUnstyledText(pText.substring(lastIndex, matcher.end()), pResult, pOriginalStyle);
            } else if (matcher.start() > 0 && pText.charAt(matcher.start() - 1) == '\\') {
                this.appendUnstyledText(pText.substring(lastIndex, matcher.start() - 1), pResult, pOriginalStyle);
                this.appendUnstyledText(matcher.group(0), pResult, pOriginalStyle);
            } else {
                this.appendUnstyledText(pText.substring(lastIndex, matcher.start()), pResult, pOriginalStyle);
                pSpecialTextHandler.accept(matcher, pResult);
            }
            lastIndex = matcher.end();
        }
        this.appendUnstyledText(pText.substring(lastIndex), pResult, pOriginalStyle);
    }

    protected void processComponentTextWithFormatting(@NotNull String pText, @NotNull Style pOriginalStyle, @NotNull MutableComponent pResult, @NotNull Pattern pPattern) {
        this.processComponentText(pText, pOriginalStyle, pResult, pPattern, (matcher, res) -> this.appendFormattedText(matcher.group(1), pOriginalStyle, (MutableComponent)res));
    }

    @NotNull
    protected MutableComponent processSiblings(@NotNull MutableComponent pComponent, @NotNull Pattern pPattern, @NotNull QuadConsumer<String, Style, MutableComponent, Pattern> pSiblingProcessor) {
        MutableComponent result = Component.empty();
        for (Component sibling : pComponent.getSiblings()) {
            if (sibling instanceof MutableComponent) {
                MutableComponent mutableSibling = (MutableComponent)sibling;
                pSiblingProcessor.accept(mutableSibling.getString(), mutableSibling.getStyle(), result, pPattern);
                continue;
            }
            result.append(sibling);
        }
        return result;
    }

    @NotNull
    protected MutableComponent processSiblingsWithFormatting(@NotNull MutableComponent pComponent, @NotNull Pattern pPattern) {
        return this.processSiblings(pComponent, pPattern, this::processComponentTextWithFormatting);
    }

    protected void appendFormattedText(@NotNull String pText, @NotNull Style pStyle, @NotNull MutableComponent pResult) {
        pResult.append((Component)Component.literal((String)pText).setStyle(pStyle));
    }

    protected void appendUnstyledText(@NotNull String pText, @NotNull MutableComponent pResult, @NotNull Style pOriginalStyle) {
        pResult.append((Component)Component.literal((String)pText).setStyle(pOriginalStyle));
    }

    @NotNull
    protected abstract Boolean isFeatureEnabled();

    @NotNull
    protected abstract String getFeatureName();
}

