/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.net.messages.client.loader;

import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.net.NetworkPacket;
import software.bluelib.internal.BlueResource;
import software.bluelib.loader.geckolib.constant.dataticket.SerializableDataTicket;

public record BlockEntityDataSyncPacket<D>(@NotNull BlockPos pos, @NotNull SerializableDataTicket<D> dataTicket, @NotNull D data) implements NetworkPacket<BlockEntityDataSyncPacket<D>>
{
    @NotNull
    public static final ResourceLocation ID = BlueResource.resource("blockentity_data_sync");

    @Override
    public void encode(@NotNull RegistryFriendlyByteBuf pBuffer) {
        SerializableDataTicket.STREAM_CODEC.encode((Object)pBuffer, this.dataTicket);
        pBuffer.writeBlockPos(this.pos);
        this.dataTicket.streamCodec().encode((Object)pBuffer, this.data);
    }

    @NotNull
    public static <D> BlockEntityDataSyncPacket<D> decode(@NotNull RegistryFriendlyByteBuf pBuffer) {
        SerializableDataTicket dataTicket = (SerializableDataTicket)SerializableDataTicket.STREAM_CODEC.decode((Object)pBuffer);
        BlockPos pos = pBuffer.readBlockPos();
        Object data = dataTicket.streamCodec().decode((Object)pBuffer);
        return new BlockEntityDataSyncPacket<Object>(pos, dataTicket, data);
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return ID;
    }
}

