/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.net.messages.client.loader;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.net.NetworkPacket;
import software.bluelib.internal.BlueResource;
import software.bluelib.loader.geckolib.constant.dataticket.SerializableDataTicket;

public record EntityDataSyncPacket<D>(@NotNull Integer entityId, boolean isReplacedEntity, @NotNull SerializableDataTicket<D> dataTicket, @NotNull D data) implements NetworkPacket<EntityDataSyncPacket<D>>
{
    public static final ResourceLocation ID = BlueResource.resource("entity_data_sync");

    @Override
    public void encode(@NotNull RegistryFriendlyByteBuf pBuffer) {
        SerializableDataTicket.STREAM_CODEC.encode((Object)pBuffer, this.dataTicket);
        pBuffer.writeVarInt(this.entityId.intValue());
        pBuffer.writeBoolean(this.isReplacedEntity);
        this.dataTicket.streamCodec().encode((Object)pBuffer, this.data);
    }

    @NotNull
    public static <D> EntityDataSyncPacket<D> decode(@NotNull RegistryFriendlyByteBuf pBuffer) {
        SerializableDataTicket dataTicket = (SerializableDataTicket)SerializableDataTicket.STREAM_CODEC.decode((Object)pBuffer);
        Integer entityId = pBuffer.readVarInt();
        boolean isReplacedEntity = pBuffer.readBoolean();
        Object data = dataTicket.streamCodec().decode((Object)pBuffer);
        return new EntityDataSyncPacket<Object>(entityId, isReplacedEntity, dataTicket, data);
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return ID;
    }
}

