/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.net.messages.client.variant;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.net.NetworkPacket;
import software.bluelib.internal.BlueResource;

public record VariantsPacket(@NotNull Set<String> allVariants) implements NetworkPacket<VariantsPacket>
{
    @NotNull
    public static final ResourceLocation ID = BlueResource.resource("variants_packet");

    @Override
    public void encode(@NotNull RegistryFriendlyByteBuf pBuffer) {
        pBuffer.writeCollection(this.allVariants, FriendlyByteBuf::writeUtf);
    }

    @NotNull
    public static VariantsPacket decode(@NotNull RegistryFriendlyByteBuf pBuffer) {
        Set allVariants = (Set)pBuffer.readCollection(HashSet::new, FriendlyByteBuf::readUtf);
        return new VariantsPacket(allVariants);
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return ID;
    }
}

