/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.json.cache.pos;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;
import software.bluelib.api.json.deserializer.pos.Vector2;

public record Vector2Cache(@NotNull Float x, @NotNull Float y) {
    @NotNull
    public static final Codec<Vector2Cache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)Vector2Cache.readFromNBT(tag));
    }, vector2Cache -> {
        CompoundTag tag = new CompoundTag();
        vector2Cache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    @NotNull
    public static final DataComponentType<Vector2Cache> VECTOR2_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putFloat("x", this.x.floatValue());
        pTag.putFloat("y", this.y.floatValue());
    }

    @NotNull
    public static Vector2Cache readFromNBT(@NotNull CompoundTag pTag) {
        return new Vector2Cache(Float.valueOf(pTag.getFloat("x")), Float.valueOf(pTag.getFloat("y")));
    }

    @NotNull
    public static Vector2Cache construct(@NotNull Vector2 pVectorRange) {
        return new Vector2Cache(pVectorRange.x(), pVectorRange.y());
    }

    public static Vector2f convert(@NotNull Vector2 pVector) {
        return new Vector2f(pVector.x().floatValue(), pVector.y().floatValue());
    }

    public static Vector2f convert(@NotNull Vector2Cache pVector) {
        return new Vector2f(pVector.x().floatValue(), pVector.y().floatValue());
    }
}

