/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.json.cache.range;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.json.deserializer.range.DoubleRange;

public record DoubleRangeCache(@NotNull Double min, @NotNull Double max) {
    @NotNull
    public static final Codec<DoubleRangeCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)DoubleRangeCache.readFromNBT(tag));
    }, doubleRangeCache -> {
        CompoundTag tag = new CompoundTag();
        doubleRangeCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    @NotNull
    public static final DataComponentType<DoubleRangeCache> DOUBLE_RANGE_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putDouble("Min", this.min.doubleValue());
        pTag.putDouble("Max", this.max.doubleValue());
    }

    @NotNull
    public static DoubleRangeCache readFromNBT(@NotNull CompoundTag pTag) {
        return new DoubleRangeCache(pTag.getDouble("Min"), pTag.getDouble("Max"));
    }

    public double getRandomValue() {
        return ThreadLocalRandom.current().nextDouble() * (this.max - this.min) + this.min;
    }

    @NotNull
    public static DoubleRangeCache construct(@NotNull DoubleRange pDoubleRange) {
        return new DoubleRangeCache(pDoubleRange.min(), pDoubleRange.max());
    }
}

