/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.net;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.net.NetworkPacket;
import software.bluelib.api.net.PacketProvider;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;
import software.bluelib.net.PacketRegisterInfo;

public class NetworkRegistry {
    @NotNull
    private static final List<PacketProvider.C2SPacketProvider> c2sProviders = new ArrayList<PacketProvider.C2SPacketProvider>();
    @NotNull
    private static final List<PacketProvider.S2CPacketProvider> s2cProviders = new ArrayList<PacketProvider.S2CPacketProvider>();
    @Nullable
    private static List<PacketRegisterInfo<?>> c2sPayloads = null;
    @Nullable
    private static List<PacketRegisterInfo<?>> s2cPayloads = null;

    public static void sendPacket(@NotNull ServerPlayer pPlayer, @NotNull NetworkPacket<?> pPacket) {
        NetworkRegistry.sendPacketToPlayer(pPlayer, pPacket);
    }

    public static void sendToServer(@NotNull NetworkPacket<?> pPacket) {
        BlueLibConstants.PlatformHelper.REGISTRY.getNetwork().sendToServer(pPacket);
    }

    public static void sendPacketToPlayer(@NotNull ServerPlayer pPlayer, @NotNull NetworkPacket<?> pPacket) {
        BlueLibConstants.PlatformHelper.REGISTRY.getNetwork().sendPacketToPlayer(pPlayer, pPacket);
    }

    public static void sendToAllPlayers(@NotNull NetworkPacket<?> pPacket) {
        MinecraftServer server = BlueLibConstants.PlatformHelper.PLATFORM.getServer();
        if (server == null) {
            BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, BlueTranslation.translate("server.null"));
            return;
        }
        NetworkRegistry.sendPacketToPlayers(server.getPlayerList().getPlayers(), pPacket);
    }

    public static void sendPacketToPlayers(@NotNull Iterable<ServerPlayer> pPlayers, @NotNull NetworkPacket<?> pPacket) {
        for (ServerPlayer player : pPlayers) {
            NetworkRegistry.sendPacketToPlayer(player, pPacket);
        }
    }

    public static void sendToAllPlayersTrackingEntity(@NotNull Entity pTrackingEntity, @NotNull NetworkPacket<?> pPacket) {
        BlueLibConstants.PlatformHelper.REGISTRY.getNetwork().sendToAllPlayersTrackingEntity(pTrackingEntity, pPacket);
    }

    public static void sendToAllPlayersTrackingBlock(@NotNull ServerLevel pLevel, @NotNull BlockPos pBlockPos, @NotNull NetworkPacket<?> pPacket) {
        BlueLibConstants.PlatformHelper.REGISTRY.getNetwork().sendToAllPlayersTrackingBlock(pLevel, pBlockPos, pPacket);
    }

    @NotNull
    public static List<PacketRegisterInfo<?>> getC2SPayloads() {
        if (c2sPayloads == null) {
            c2sPayloads = NetworkRegistry.generateC2SPacketInfoList();
        }
        return c2sPayloads;
    }

    @NotNull
    public static List<PacketRegisterInfo<?>> getS2CPayloads() {
        if (s2cPayloads == null) {
            s2cPayloads = NetworkRegistry.generateS2CPacketInfoList();
        }
        return s2cPayloads;
    }

    @NotNull
    private static List<PacketRegisterInfo<?>> generateS2CPacketInfoList() {
        ArrayList list = new ArrayList();
        for (PacketProvider.S2CPacketProvider provider : s2cProviders) {
            list.addAll(provider.getS2CPacketInfoList());
        }
        return list;
    }

    @NotNull
    private static List<PacketRegisterInfo<?>> generateC2SPacketInfoList() {
        ArrayList list = new ArrayList();
        for (PacketProvider.C2SPacketProvider provider : c2sProviders) {
            list.addAll(provider.getC2SPacketInfoList());
        }
        return list;
    }

    public static void registerC2SPacketProvider(@NotNull PacketProvider.C2SPacketProvider pProvider) {
        c2sProviders.add(pProvider);
        c2sPayloads = null;
    }

    public static void registerS2CPacketProvider(@NotNull PacketProvider.S2CPacketProvider pProvider) {
        s2cProviders.add(pProvider);
        s2cPayloads = null;
    }
}

