/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.conversion;

import java.awt.Color;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;

public class ColorConverterUtils {
    @NotNull
    public static Integer parseColorToHexString(@NotNull String pInput) {
        Integer b;
        Integer g;
        Integer r;
        Matcher matcher;
        if (((String)pInput).matches("^([0-9A-Fa-f]{6})$")) {
            pInput = "#" + (String)pInput;
        }
        String rgbPattern = "\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*\\)";
        String argbPattern = "\\(\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*,\\s*(\\d{1,3})\\s*\\)";
        String hexPattern = "^#([0-9A-Fa-f]{6})$";
        String hex0xPattern = "^0x([0-9A-Fa-f]{6})$";
        if (((String)pInput).matches(rgbPattern) && (matcher = Pattern.compile(rgbPattern).matcher((CharSequence)pInput)).matches() && ColorConverterUtils.isValidRGB(r = Integer.valueOf(Integer.parseInt(matcher.group(1))), g = Integer.valueOf(Integer.parseInt(matcher.group(2))), b = Integer.valueOf(Integer.parseInt(matcher.group(3)))).booleanValue()) {
            return ColorConverterUtils.toHex(r, g, b);
        }
        if (((String)pInput).matches(argbPattern) && (matcher = Pattern.compile(argbPattern).matcher((CharSequence)pInput)).matches() && ColorConverterUtils.isValidRGB(r = Integer.valueOf(Integer.parseInt(matcher.group(2))), g = Integer.valueOf(Integer.parseInt(matcher.group(3))), b = Integer.valueOf(Integer.parseInt(matcher.group(4)))).booleanValue()) {
            return ColorConverterUtils.toHex(r, g, b);
        }
        if (((String)pInput).matches(hexPattern)) {
            return Integer.parseInt(((String)pInput).substring(1), 16);
        }
        if (((String)pInput).matches(hex0xPattern)) {
            return Integer.parseInt(((String)pInput).substring(2), 16);
        }
        return 0xFFFFFF;
    }

    @NotNull
    private static Boolean isValidRGB(@NotNull Integer pRed, @NotNull Integer pGreen, @NotNull Integer pBlue) {
        return ColorConverterUtils.isInRange(pRed) && ColorConverterUtils.isInRange(pGreen) && ColorConverterUtils.isInRange(pBlue);
    }

    private static boolean isInRange(@NotNull Integer pValue) {
        return pValue >= 0 && pValue <= 255;
    }

    @NotNull
    private static Integer toHex(@NotNull Integer pRed, @NotNull Integer pGreen, @NotNull Integer pBlue) {
        return pRed << 16 | pGreen << 8 | pBlue;
    }

    @NotNull
    public static Optional<Color> getParsedColor(@NotNull String pColor) {
        try {
            if (pColor.contains("#")) {
                return Optional.of(Color.decode(pColor));
            }
            return Optional.of(new Color(DyeColor.valueOf((String)pColor.toUpperCase(Locale.ROOT)).getTextColor()));
        }
        catch (IllegalArgumentException pException) {
            BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, BlueTranslation.log("color.notvalid", pColor));
            return Optional.empty();
        }
    }

    @NotNull
    public static Optional<String> getParsedColorName(@NotNull String pColor) {
        try {
            if (!pColor.contains("#")) {
                return Optional.of(DyeColor.valueOf((String)pColor.toUpperCase(Locale.ROOT)).getName());
            }
        }
        catch (IllegalArgumentException pException) {
            BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, BlueTranslation.log("color.notvalid", pColor));
            return Optional.empty();
        }
        return Optional.empty();
    }

    @NotNull
    public static Integer rgbToDecimal(@NotNull Integer pRed, @NotNull Integer pGreen, @NotNull Integer pBlue) {
        return (pRed << 16) + (pGreen << 8) + pBlue;
    }
}

