/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.net.NetworkRegistry;
import software.bluelib.internal.BlueTranslation;
import software.bluelib.net.messages.client.OpenLoggerPacket;

public class OpenLoggerScreenCommand {
    public static void register(@NotNull CommandDispatcher<CommandSourceStack> pDispatcher) {
        pDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"log").executes(OpenLoggerScreenCommand::openLogScreen));
    }

    private static int openLogScreen(@NotNull CommandContext<CommandSourceStack> pContext) {
        ServerPlayer player = ((CommandSourceStack)pContext.getSource()).getPlayer();
        if (player == null) {
            ((CommandSourceStack)pContext.getSource()).sendFailure(BlueTranslation.translate("command.logger.no_player"));
            return 0;
        }
        if (player.hasPermissions(3)) {
            NetworkRegistry.sendPacketToPlayer(player, new OpenLoggerPacket());
        } else {
            ((CommandSourceStack)pContext.getSource()).sendFailure(BlueTranslation.translate("command.logger.no_permission"));
        }
        return 1;
    }
}

