/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.entity.variant.IVariantProvider;
import software.bluelib.api.json.JSONMerger;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.loader.cache.animations.AnimationCache;
import software.bluelib.loader.cache.animations.AnimationLibraryCache;
import software.bluelib.loader.cache.animations.keyframe.KeyframeLibraryCache;
import software.bluelib.loader.cache.controller.ControllerCache;
import software.bluelib.loader.cache.model.ModelCache;
import software.bluelib.loader.cache.variants.EntityCache;
import software.bluelib.loader.json.CacheFactory;
import software.bluelib.loader.json.FormatVersion;
import software.bluelib.loader.json.animation.AnimationCacheFactory;
import software.bluelib.loader.json.animation.AnimationFormatVersion;
import software.bluelib.loader.json.controller.ControllerCacheFactory;
import software.bluelib.loader.json.controller.ControllerFormatVersion;
import software.bluelib.loader.json.deserialize.animation.AnimationLibrary;
import software.bluelib.loader.json.deserialize.animation.BakedAnimationsAdapter;
import software.bluelib.loader.json.deserialize.animation.KeyFramesAdapter;
import software.bluelib.loader.json.deserialize.controller.Animation;
import software.bluelib.loader.json.deserialize.controller.Behaviour;
import software.bluelib.loader.json.deserialize.controller.Controller;
import software.bluelib.loader.json.deserialize.controller.Group;
import software.bluelib.loader.json.deserialize.controller.State;
import software.bluelib.loader.json.deserialize.model.Bone;
import software.bluelib.loader.json.deserialize.model.Cube;
import software.bluelib.loader.json.deserialize.model.FaceUV;
import software.bluelib.loader.json.deserialize.model.LocatorClass;
import software.bluelib.loader.json.deserialize.model.LocatorValue;
import software.bluelib.loader.json.deserialize.model.Model;
import software.bluelib.loader.json.deserialize.model.ModelDescription;
import software.bluelib.loader.json.deserialize.model.ModelGeometry;
import software.bluelib.loader.json.deserialize.model.PolyMesh;
import software.bluelib.loader.json.deserialize.model.PolysUnion;
import software.bluelib.loader.json.deserialize.model.TextureMesh;
import software.bluelib.loader.json.deserialize.model.UVFaces;
import software.bluelib.loader.json.deserialize.model.UVUnion;
import software.bluelib.loader.json.deserialize.variants.Entity;
import software.bluelib.loader.json.deserialize.variants.Variant;
import software.bluelib.loader.json.model.ModelCacheFactory;
import software.bluelib.loader.json.model.ModelFormatVersion;
import software.bluelib.loader.json.variants.VariantsCacheFactory;
import software.bluelib.loader.json.variants.VariantsFormatVersion;

public class BlueLoader {
    @NotNull
    public static final Gson MODEL_GSON = new GsonBuilder().setLenient().registerTypeAdapter(Bone.class, Bone.deserializer()).registerTypeAdapter(Cube.class, Cube.deserializer()).registerTypeAdapter(FaceUV.class, FaceUV.deserializer()).registerTypeAdapter(LocatorClass.class, LocatorClass.deserializer()).registerTypeAdapter(LocatorValue.class, LocatorValue.deserializer()).registerTypeAdapter(ModelGeometry.class, ModelGeometry.deserializer()).registerTypeAdapter(Model.class, Model.deserializer()).registerTypeAdapter(ModelDescription.class, ModelDescription.deserializer()).registerTypeAdapter(PolyMesh.class, PolyMesh.deserializer()).registerTypeAdapter(PolysUnion.class, PolysUnion.deserializer()).registerTypeAdapter(TextureMesh.class, TextureMesh.deserializer()).registerTypeAdapter(UVFaces.class, UVFaces.deserializer()).registerTypeAdapter(UVUnion.class, UVUnion.deserializer()).create();
    @NotNull
    public static final Gson ANIMATION_GSON = new GsonBuilder().setLenient().registerTypeAdapter(KeyframeLibraryCache.class, (Object)new KeyFramesAdapter()).registerTypeAdapter(AnimationLibraryCache.class, (Object)new BakedAnimationsAdapter()).create();
    @NotNull
    public static final Gson CONTROLLER_GSON = new GsonBuilder().setLenient().registerTypeAdapter(Controller.class, Controller.deserializer()).registerTypeAdapter(Group.class, Group.deserializer()).registerTypeAdapter(Behaviour.class, Behaviour.deserializer()).registerTypeAdapter(State.class, State.deserializer()).registerTypeAdapter(Animation.class, Animation.deserializer()).create();
    @NotNull
    public static final Gson VARIANTS_GSON = new GsonBuilder().registerTypeAdapter(Entity.class, Entity.deserializer()).registerTypeAdapter(Variant.class, Variant.deserializer()).setPrettyPrinting().create();

    @NotNull
    private static ResourceLocation stripPrefixAndSuffix(@NotNull ResourceLocation pResourceLocation) {
        BaseLogger.log((Boolean)true, BaseLogLevel.INFO, String.format("Stripping prefix and suffix for: %1$s", pResourceLocation));
        String newPath = pResourceLocation.getPath();
        Matcher prefixMatcher = BlueLibConstants.BlueLoader.PREFIX_STRIPPER.matcher(newPath);
        newPath = prefixMatcher.find() ? newPath.substring(prefixMatcher.end()) : newPath;
        Matcher suffixMatcher = BlueLibConstants.BlueLoader.SUFFIX_STRIPPER.matcher(newPath);
        newPath = suffixMatcher.find() ? newPath.substring(0, suffixMatcher.start()) : newPath;
        ResourceLocation result = newPath.length() == pResourceLocation.getPath().length() ? pResourceLocation : pResourceLocation.withPath(newPath);
        BaseLogger.log((Boolean)true, BaseLogLevel.INFO, String.format("Result after strip: %1$s", result));
        return result;
    }

    @NotNull
    protected static CompletableFuture<Map<ResourceLocation, ControllerCache>> loadControllers(@NotNull Executor pBackgroundExecutor, @NotNull ResourceManager pResourceManager) {
        return BlueLoader.bakeJsonResources(pBackgroundExecutor, pResourceManager, BlueLibConstants.BlueLoader.CONTROLLERS_PATH.getPath(), BlueLoader::bakeController, ex -> null);
    }

    @NotNull
    protected static CompletableFuture<Map<ResourceLocation, AnimationLibraryCache>> loadAnimations(@NotNull Executor pBackgroundExecutor, @NotNull ResourceManager pResourceManager) {
        return BlueLoader.bakeJsonResources(pBackgroundExecutor, pResourceManager, BlueLibConstants.BlueLoader.ANIMATIONS_PATH.getPath(), BlueLoader::bakeAnimations, ex -> new AnimationLibraryCache((Map<String, AnimationCache>)new Object2ObjectOpenHashMap()));
    }

    @NotNull
    protected static CompletableFuture<Map<ResourceLocation, ModelCache>> loadModels(@NotNull Executor pBackgroundExecutor, @NotNull ResourceManager pResourceManager) {
        return BlueLoader.bakeJsonResources(pBackgroundExecutor, pResourceManager, BlueLibConstants.BlueLoader.MODELS_PATH.getPath(), BlueLoader::bakeModel, ex -> null);
    }

    @NotNull
    protected static CompletableFuture<Map<ResourceLocation, EntityCache>> loadVariants(@NotNull Executor pBackgroundExecutor, @NotNull ResourceManager pResourceManager, @NotNull List<IVariantProvider> pProviders) {
        BaseLogger.log((Boolean)true, BaseLogLevel.INFO, String.format("Starting loadVariants with providers: %1$s", pProviders.size()));
        ObjectArrayList futures = new ObjectArrayList();
        for (IVariantProvider provider : pProviders) {
            for (String entity : provider.getEntityNames()) {
                if (BlueLibConstants.PlatformHelper.EVENT_PROXY.allVariantsLoadedPre(entity).booleanValue()) {
                    BaseLogger.log((Boolean)true, BaseLogLevel.INFO, String.format("variant loading cancelled for entity: %1$s", entity));
                    continue;
                }
                String entityPath = provider.getBasePath() + entity;
                BaseLogger.log((Boolean)true, BaseLogLevel.INFO, String.format("Processing entity: %1$s", entityPath));
                Map resources = pResourceManager.listResources(entityPath, fileName -> fileName.getPath().endsWith(".json"));
                JsonObject merged = new JsonObject();
                for (Map.Entry entry : resources.entrySet()) {
                    JsonObject obj = BlueLoader.readJsonFile((ResourceLocation)entry.getKey(), (Resource)entry.getValue());
                    JSONMerger.mergeJsonObjects(merged, obj);
                }
                String namespace = resources.isEmpty() ? "minecraft" : ((ResourceLocation)resources.keySet().iterator().next()).getNamespace();
                ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)entity);
                futures.add(CompletableFuture.supplyAsync(() -> {
                    if (BlueLibConstants.PlatformHelper.EVENT_PROXY.variantLoadedPre(entity, key.toString()).booleanValue()) {
                        BaseLogger.log((Boolean)true, BaseLogLevel.INFO, String.format("variant loading cancelled for: %1$s", key));
                        return null;
                    }
                    EntityCache cache = BlueLoader.bakeVariants(key, merged);
                    BlueLibConstants.PlatformHelper.EVENT_PROXY.variantLoadedPost(entity, key.toString());
                    return Map.entry(key, cache);
                }, pBackgroundExecutor));
                BlueLibConstants.PlatformHelper.EVENT_PROXY.allVariantsLoadedPost(entity);
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(arg_0 -> BlueLoader.lambda$loadVariants$5((List)futures, arg_0));
    }

    @NotNull
    protected static <BAKED> CompletableFuture<Map<ResourceLocation, BAKED>> bakeJsonResources(@NotNull Executor pBackgroundExecutor, @NotNull ResourceManager pResourceManager, @NotNull String pAssetPath, @NotNull BiFunction<ResourceLocation, JsonObject, BAKED> pElementFactory, @NotNull Function<Throwable, BAKED> pExceptionalFactory) {
        return ((CompletableFuture)BlueLoader.loadResources(pBackgroundExecutor, pResourceManager, pAssetPath, "json", BlueLoader::readJsonFile).thenCompose(pResources -> {
            ObjectArrayList tasks = new ObjectArrayList(pResources.size());
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, String.format("Resources to bake: %1$s", Arrays.toString(pResources.stream().map(Pair::left).toList().toArray())));
            pResources.forEach(arg_0 -> BlueLoader.lambda$bakeJsonResources$7((List)tasks, pElementFactory, pExceptionalFactory, pBackgroundExecutor, arg_0));
            return CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).thenApply(arg_0 -> BlueLoader.lambda$bakeJsonResources$9((List)tasks, arg_0));
        })).exceptionally(ex -> {
            BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, "bakeJsonResources failed: " + ex.getMessage());
            return Collections.emptyMap();
        });
    }

    @NotNull
    protected static <UNBAKED> CompletableFuture<List<Pair<ResourceLocation, UNBAKED>>> loadResources(@NotNull Executor pExecutor, @NotNull ResourceManager pResourceManager, @NotNull String pAssetPath, @NotNull String pFileType, @NotNull BiFunction<ResourceLocation, Resource, UNBAKED> pElementFactory) {
        String fileTypeSuffix = "." + pFileType;
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Map allResources = pResourceManager.listResources(pAssetPath, fileName -> fileName.getPath().endsWith(fileTypeSuffix));
            Map<ResourceLocation, Resource> listed = allResources.entrySet().stream().filter(entry -> !BlueLibConstants.BlueLoader.SKIPPED_NAMESPACES.contains(((ResourceLocation)entry.getKey()).getNamespace())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, String.format("Resource keys found after filtering: %1$s", Arrays.toString(listed.keySet().toArray())));
            return listed;
        }, pExecutor).thenCompose(pFilteredResources -> {
            ObjectArrayList tasks = new ObjectArrayList(pFilteredResources.size());
            pFilteredResources.forEach((arg_0, arg_1) -> BlueLoader.lambda$loadResources$16((List)tasks, pElementFactory, pExecutor, arg_0, arg_1));
            return CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).thenApply(arg_0 -> BlueLoader.lambda$loadResources$17((List)tasks, arg_0));
        })).exceptionally(ex -> {
            BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, "loadResources failed: " + ex.getMessage());
            return List.of();
        });
    }

    @NotNull
    protected static ModelCache bakeModel(@NotNull ResourceLocation pResourceLocation, @NotNull JsonObject pJsonObject) {
        return BlueLoader.bakeGeneric(pResourceLocation, pJsonObject, MODEL_GSON, Model.class, Model::formatVersion, ModelFormatVersion.REGISTRY::match, FormatVersion::isSupported, FormatVersion::getErrorMessage, (namespace, model) -> (ModelCache)CacheFactory.constructWithFactory(ModelCacheFactory.REGISTRY::getForNamespace, namespace, model), List.of(Pair.of(loc -> loc.getPath().endsWith(".animation.json"), (Object)".animation.json"), Pair.of(loc -> loc.getPath().endsWith(".controller.json"), (Object)".controller.json")));
    }

    @NotNull
    protected static AnimationLibraryCache bakeAnimations(@NotNull ResourceLocation pResourceLocation, @NotNull JsonObject pJsonObject) {
        return BlueLoader.bakeGeneric(pResourceLocation, pJsonObject, ANIMATION_GSON, AnimationLibrary.class, AnimationLibrary::formatVersion, AnimationFormatVersion.REGISTRY::match, FormatVersion::isSupported, FormatVersion::getErrorMessage, (namespace, animations) -> (AnimationLibraryCache)CacheFactory.constructWithFactory(AnimationCacheFactory.REGISTRY::getForNamespace, namespace, animations), List.of(Pair.of(loc -> loc.getPath().endsWith(".geo.json"), (Object)".geo.json"), Pair.of(loc -> loc.getPath().endsWith(".controller.json"), (Object)".controller.json")));
    }

    @NotNull
    protected static ControllerCache bakeController(@NotNull ResourceLocation pResourceLocation, @NotNull JsonObject pJsonObject) {
        return BlueLoader.bakeGeneric(pResourceLocation, pJsonObject, CONTROLLER_GSON, Controller.class, Controller::formatVersion, ControllerFormatVersion.REGISTRY::match, FormatVersion::isSupported, FormatVersion::getErrorMessage, (namespace, controller) -> (ControllerCache)CacheFactory.constructWithFactory(ControllerCacheFactory.REGISTRY::getForNamespace, namespace, controller), List.of(Pair.of(loc -> loc.getPath().endsWith(".geo.json"), (Object)".geo.json"), Pair.of(loc -> loc.getPath().endsWith(".animation.json"), (Object)".animation.json")));
    }

    @NotNull
    protected static EntityCache bakeVariants(@NotNull ResourceLocation pResourceLocation, @NotNull JsonObject pJsonObject) {
        return BlueLoader.bakeGeneric(pResourceLocation, pJsonObject, VARIANTS_GSON, Entity.class, Entity::formatVersion, VariantsFormatVersion.REGISTRY::match, FormatVersion::isSupported, FormatVersion::getErrorMessage, (namespace, controller) -> (EntityCache)CacheFactory.constructWithFactory(VariantsCacheFactory.REGISTRY::getForNamespace, namespace, controller), null);
    }

    @NotNull
    public static <T, V, C> C bakeGeneric(@NotNull ResourceLocation pResourceLocation, @NotNull JsonObject pJsonObject, @NotNull Gson pGson, @NotNull Class<T> pModelClass, @NotNull Function<T, String> pVersionExtractor, @NotNull Function<String, V> pVersionMatcher, @NotNull Predicate<V> pIsSupported, @NotNull Function<V, String> pErrorMessage, @NotNull BiFunction<String, T, C> pCacheFactory, @Nullable List<Pair<Predicate<ResourceLocation>, String>> pFileChecks) {
        Object model;
        String version;
        V matchedVersion;
        if (pFileChecks != null) {
            String path = pResourceLocation.getPath();
            String folderName = path.contains("/") ? path.substring(0, path.indexOf(47)) : path;
            for (Pair<Predicate<ResourceLocation>, String> check : pFileChecks) {
                if (!((Predicate)check.left()).test(pResourceLocation)) continue;
                BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, String.format("File check failed for: %1$s", pResourceLocation));
                throw new RuntimeException(String.format("Found %s in %s folder! '%s'", check.right(), folderName, pResourceLocation));
            }
        }
        if ((matchedVersion = pVersionMatcher.apply(version = pVersionExtractor.apply(model = pGson.fromJson((JsonElement)pJsonObject, pModelClass)))) == null) {
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, String.format("%1$s: Unknown format version: '%2$s'. This may not work correctly", pResourceLocation, version));
        } else if (!pIsSupported.test(matchedVersion)) {
            BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, String.format("%1$s: Unsupported format version: '%2$s'. %3$s", pResourceLocation, version, pErrorMessage.apply(matchedVersion)));
        }
        return pCacheFactory.apply(pResourceLocation.getNamespace(), (String)model);
    }

    @NotNull
    protected static JsonObject readJsonFile(@NotNull ResourceLocation pResourceLocation, @NotNull Resource pResource) {
        JsonObject jsonObject;
        block8: {
            BufferedReader reader = pResource.openAsReader();
            try {
                jsonObject = GsonHelper.parse((Reader)reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException pIoException) {
                    BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, String.format("Failed to read resource: %1$s - %2$s", pResourceLocation, pIoException.getMessage()));
                    throw new RuntimeException("Failed to read resource: " + String.valueOf(pResourceLocation), pIoException);
                }
            }
            ((Reader)reader).close();
        }
        return jsonObject;
    }

    private static /* synthetic */ List lambda$loadResources$17(List tasks, Void pIgnored) {
        return tasks.stream().map(CompletableFuture::join).filter(Objects::nonNull).toList();
    }

    private static /* synthetic */ void lambda$loadResources$16(List tasks, BiFunction pElementFactory, Executor pExecutor, ResourceLocation pPath, Resource pResource) {
        BaseLogger.log((Boolean)true, BaseLogLevel.INFO, String.format("Loading path: %1$s with resource: %2$s", pPath.toString(), pResource.toString()));
        tasks.add(CompletableFuture.supplyAsync(() -> {
            try {
                return Pair.of((Object)pPath, pElementFactory.apply(pPath, pResource));
            }
            catch (Exception e) {
                BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, String.format("Failed to read/parse resource %s: %s", pPath, e.getMessage()));
                return null;
            }
        }, pExecutor));
    }

    private static /* synthetic */ Map lambda$bakeJsonResources$9(List tasks, Void pIgnored) {
        return tasks.stream().map(CompletableFuture::join).filter(Objects::nonNull).filter(pair -> pair.right() != null).collect(Collectors.toMap(Pair::left, Pair::right));
    }

    private static /* synthetic */ void lambda$bakeJsonResources$7(List tasks, BiFunction pElementFactory, Function pExceptionalFactory, Executor pBackgroundExecutor, Pair pPair) {
        tasks.add(CompletableFuture.supplyAsync(() -> {
            try {
                ResourceLocation key = BlueLoader.stripPrefixAndSuffix((ResourceLocation)pPair.left());
                Object baked = pElementFactory.apply((ResourceLocation)pPair.left(), (JsonObject)pPair.right());
                return baked == null ? null : Pair.of((Object)key, baked);
            }
            catch (Exception e) {
                BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, String.format("Error baking %s: %s", pPair.left(), e.getMessage()));
                Object fallback = pExceptionalFactory.apply(e);
                return fallback == null ? null : Pair.of((Object)((ResourceLocation)pPair.left()), fallback);
            }
        }, pBackgroundExecutor));
    }

    private static /* synthetic */ Map lambda$loadVariants$5(List futures, Void pIgnored) {
        HashMap<ResourceLocation, EntityCache> combined = new HashMap<ResourceLocation, EntityCache>();
        for (CompletableFuture future : futures) {
            Map.Entry entry = (Map.Entry)future.join();
            if (entry == null) continue;
            combined.put((ResourceLocation)entry.getKey(), (EntityCache)entry.getValue());
        }
        return combined;
    }
}

