/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animatable.base;

import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.net.registry.LoaderNetwork;
import software.bluelib.api.utils.loader.LoaderUtils;
import software.bluelib.loader.animatable.base.AnimatableManager;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animatable.cache.AnimatableInstanceCache;
import software.bluelib.loader.animatable.cache.SingletonAnimatableInstanceCache;
import software.bluelib.loader.geckolib.constant.dataticket.SerializableDataTicket;
import software.bluelib.loader.renderer.client.BlueRenderProvider;

public interface SingletonBlueAnimatable
extends BlueAnimatable {
    public static void registerSyncedAnimatable(@NotNull BlueAnimatable pAnimatable) {
        LoaderUtils.registerSyncedAnimatable(pAnimatable);
    }

    @ApiStatus.NonExtendable
    @Nullable
    default public <D> D getAnimData(long pInstanceId, @NotNull SerializableDataTicket<D> pDataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(pInstanceId).getData(pDataTicket);
    }

    @ApiStatus.NonExtendable
    default public <D> void setAnimData(@NotNull Entity pRelatedEntity, long pInstanceId, @NotNull SerializableDataTicket<D> pDataTicket, D pData) {
        if (pRelatedEntity.level().isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(pInstanceId).setData(pDataTicket, pData);
        } else {
            this.syncAnimData(pInstanceId, pDataTicket, pData, pRelatedEntity);
        }
    }

    @ApiStatus.NonExtendable
    default public <D> void syncAnimData(long pInstanceId, @NotNull SerializableDataTicket<D> pDataTicket, @NotNull D pData, @NotNull Entity pEntityToTrack) {
        LoaderNetwork.syncSingletonAnimData(this, pInstanceId, pDataTicket, pData, pEntityToTrack);
    }

    @ApiStatus.NonExtendable
    default public <D> void triggerAnim(@NotNull Entity pRelatedEntity, long pInstanceId, @Nullable String pControllerName, @NotNull String pAnimName) {
        if (pRelatedEntity.level().isClientSide()) {
            if (pControllerName != null) {
                this.getAnimatableInstanceCache().getManagerForId(pInstanceId).tryTriggerAnimation(pControllerName, pAnimName);
            } else {
                this.getAnimatableInstanceCache().getManagerForId(pInstanceId).tryTriggerAnimation(pAnimName);
            }
        } else {
            LoaderNetwork.triggerSingletonAnim(this, pRelatedEntity, (Long)pInstanceId, pControllerName, pAnimName);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(@NotNull Entity pRelatedEntity, long pInstanceId, @Nullable String pControllerName, @Nullable String pAnimName) {
        if (pRelatedEntity.level().isClientSide()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(pInstanceId);
            if (pControllerName != null) {
                animatableManager.stopTriggeredAnimation(pControllerName, pAnimName);
            } else {
                animatableManager.stopTriggeredAnimation(pAnimName);
            }
        } else {
            LoaderNetwork.stopTriggeredSingletonAnim(this, pRelatedEntity, pInstanceId, pControllerName, pAnimName);
        }
    }

    @ApiStatus.NonExtendable
    default public void triggerArmorAnim(@NotNull Entity pRelatedEntity, long pInstanceId, @Nullable String pControllerName, @NotNull String pAnimName) {
        this.triggerAnim(pRelatedEntity, -pInstanceId, pControllerName, pAnimName);
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredArmorAnim(@NotNull Entity pRelatedEntity, long pInstanceId, @Nullable String pControllerName, @Nullable String pAnimName) {
        this.stopTriggeredAnim(pRelatedEntity, -pInstanceId, pControllerName, pAnimName);
    }

    @Nullable
    default public AnimatableInstanceCache<SingletonBlueAnimatable> useCustomCache() {
        return new SingletonAnimatableInstanceCache<SingletonBlueAnimatable>(this);
    }

    default public void createBlueRenderer(@NotNull Consumer<BlueRenderProvider> pConsumer) {
    }

    @Nullable
    default public Object getRenderProvider() {
        return this.getAnimatableInstanceCache().getRenderProvider();
    }
}

