/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animatable.entity;

import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.net.registry.LoaderNetwork;
import software.bluelib.loader.animatable.base.AnimatableManager;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.geckolib.constant.dataticket.SerializableDataTicket;

public interface BlueEntity
extends BlueAnimatable {
    @ApiStatus.NonExtendable
    @Nullable
    default public <D> D getAnimData(@NotNull SerializableDataTicket<D> pDataTicket) {
        return this.getAnimatableInstanceCache().getManagerForId(((Entity)this).getId()).getData(pDataTicket);
    }

    @ApiStatus.NonExtendable
    default public <D> void setAnimData(@NotNull SerializableDataTicket<D> pDataTicket, @NotNull D pData) {
        Entity entity = (Entity)this;
        if (entity.level().isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId(entity.getId()).setData(pDataTicket, pData);
        } else {
            LoaderNetwork.syncEntityAnimData(entity, false, pDataTicket, pData);
        }
    }

    @ApiStatus.NonExtendable
    default public void triggerAnim(@Nullable String pControllerName, @NotNull String pAnimName) {
        Entity entity = (Entity)this;
        if (entity.level().isClientSide()) {
            if (pControllerName != null) {
                this.getAnimatableInstanceCache().getManagerForId(entity.getId()).tryTriggerAnimation(pControllerName, pAnimName);
            } else {
                this.getAnimatableInstanceCache().getManagerForId(entity.getId()).tryTriggerAnimation(pAnimName);
            }
        } else {
            LoaderNetwork.triggerEntityAnim(entity, false, pControllerName, pAnimName);
        }
    }

    @ApiStatus.NonExtendable
    default public void stopTriggeredAnim(@Nullable String pControllerName, @Nullable String pAnimName) {
        Entity entity = (Entity)this;
        if (entity.level().isClientSide()) {
            AnimatableManager animatableManager = this.getAnimatableInstanceCache().getManagerForId(entity.getId());
            if (pControllerName != null) {
                animatableManager.stopTriggeredAnimation(pControllerName, pAnimName);
            } else {
                animatableManager.stopTriggeredAnimation(pAnimName);
            }
        } else {
            LoaderNetwork.stopTriggeredEntityAnim(entity, false, pControllerName, pAnimName);
        }
    }

    @Override
    @NotNull
    default public Double getTick(@NotNull Object pEntity) {
        return ((Entity)pEntity).tickCount;
    }
}

