/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animation.keyframe.handler;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.client.utils.LevelUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.AnimationController;
import software.bluelib.loader.animation.keyframe.event.SoundKeyframeEvent;

public class AutoPlayingSoundKeyframeHandler<A extends BlueAnimatable>
implements AnimationController.SoundKeyframeHandler<A> {
    @Override
    public void handle(@NotNull SoundKeyframeEvent<A> pEvent) {
        String soundData = pEvent.getKeyframeData().getSound();
        if (soundData == null || soundData.isEmpty()) {
            return;
        }
        String[] segments = soundData.split("\\|");
        if (segments.length == 0 || segments[0].isEmpty()) {
            return;
        }
        SoundEvent sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)ResourceLocation.read((String)segments[0]).getOrThrow());
        if (LevelUtils.getLevel() == null) {
            return;
        }
        if (sound != null) {
            Vec3 position;
            Entity e;
            Entity entity;
            Object t = pEvent.getAnimatable();
            Entity entity2 = entity = t instanceof Entity ? (e = (Entity)t) : null;
            if (entity != null) {
                v1 = entity.position();
            } else {
                Object t2 = pEvent.getAnimatable();
                if (t2 instanceof BlockEntity) {
                    BlockEntity blockEntity = (BlockEntity)t2;
                    v1 = blockEntity.getBlockPos().getCenter();
                } else {
                    v1 = position = null;
                }
            }
            if (position != null) {
                float volume = 1.0f;
                float pitch = 1.0f;
                try {
                    if (segments.length > 1) {
                        volume = Float.parseFloat(segments[1]);
                    }
                    if (segments.length > 2) {
                        pitch = Float.parseFloat(segments[2]);
                    }
                }
                catch (NumberFormatException e2) {
                    BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, "Invalid volume/pitch value in sound data: " + soundData, e2);
                }
                SoundSource source = entity == null ? SoundSource.BLOCKS : (entity instanceof Enemy ? SoundSource.HOSTILE : SoundSource.NEUTRAL);
                LevelUtils.getLevel().playLocalSound(position.x, position.y, position.z, sound, source, volume, pitch, false);
            }
        }
    }
}

