/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.animations;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.AnimationController;
import software.bluelib.loader.animation.keyframe.data.CustomInstructionKeyframeData;
import software.bluelib.loader.animation.keyframe.data.ParticleKeyframeData;
import software.bluelib.loader.animation.keyframe.data.SoundKeyframeData;
import software.bluelib.loader.cache.animations.keyframe.BoneAnimationCache;
import software.bluelib.loader.cache.animations.keyframe.KeyframeLibraryCache;

public record AnimationCache(@NotNull String name, double length, @NotNull LoopType loopType, @NotNull BoneAnimationCache[] boneAnimationCaches, @NotNull KeyframeLibraryCache keyFrames) {
    @NotNull
    public static AnimationCache generateWaitAnimation(double pLength) {
        return new AnimationCache("internal.wait", pLength, LoopType.PLAY_ONCE, new BoneAnimationCache[0], new KeyframeLibraryCache(new SoundKeyframeData[0], new ParticleKeyframeData[0], new CustomInstructionKeyframeData[0]));
    }

    @FunctionalInterface
    public static interface LoopType {
        @NotNull
        public static final Map<String, LoopType> LOOP_TYPES = new ConcurrentHashMap<String, LoopType>(4);
        @NotNull
        public static final LoopType DEFAULT = (animatable, controller, currentAnimation) -> currentAnimation.loopType().shouldPlayAgain(animatable, controller, currentAnimation);
        @NotNull
        public static final LoopType PLAY_ONCE = LoopType.register("play_once", LoopType.register("false", (animatable, controller, currentAnimation) -> false));
        @NotNull
        public static final LoopType HOLD_ON_LAST_FRAME = LoopType.register("hold_on_last_frame", (animatable, controller, currentAnimation) -> {
            controller.animationState = AnimationController.State.PAUSED;
            return true;
        });
        @NotNull
        public static final LoopType LOOP = LoopType.register("loop", LoopType.register("true", (animatable, controller, currentAnimation) -> true));

        public boolean shouldPlayAgain(@NotNull BlueAnimatable var1, @NotNull AnimationController<? extends BlueAnimatable> var2, @NotNull AnimationCache var3);

        @NotNull
        public static LoopType fromJson(@Nullable JsonElement pJson) {
            if (pJson == null || !pJson.isJsonPrimitive()) {
                return PLAY_ONCE;
            }
            JsonPrimitive primitive = pJson.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean() ? LOOP : PLAY_ONCE;
            }
            if (primitive.isString()) {
                return LoopType.fromString(primitive.getAsString());
            }
            return PLAY_ONCE;
        }

        @NotNull
        public static LoopType fromString(@NotNull String pName) {
            return LOOP_TYPES.getOrDefault(pName, PLAY_ONCE);
        }

        @NotNull
        public static LoopType register(@NotNull String pName, @NotNull LoopType pLoopType) {
            LOOP_TYPES.put(pName, pLoopType);
            return pLoopType;
        }
    }
}

