/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.controller;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.minecraft.CompoundTagUtils;
import software.bluelib.loader.cache.controller.GroupCache;

public record ControllerCache(@NotNull String formatVersion, @NotNull List<GroupCache> groups) {
    @NotNull
    public static final Codec<ControllerCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)ControllerCache.readFromNBT(tag));
    }, controllerCache -> {
        CompoundTag tag = new CompoundTag();
        controllerCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    @NotNull
    public static final DataComponentType<ControllerCache> CONTROLLER_CACHE_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putString("formatVersion", this.formatVersion);
        CompoundTagUtils.writeList(pTag, "groups", this.groups, (tag, data) -> data.writeToNBT((CompoundTag)tag));
    }

    @NotNull
    public static ControllerCache readFromNBT(@NotNull CompoundTag pTag) {
        String formatVersion = pTag.getString("formatVersion");
        List<GroupCache> groups = CompoundTagUtils.readList(pTag, "groups", GroupCache::readFromNBT);
        return new ControllerCache(formatVersion, groups);
    }

    @NotNull
    public GroupCache getMainGroup() {
        return this.groups.getFirst();
    }

    @Nullable
    public GroupCache getGroup(@NotNull String pGroupName) {
        for (GroupCache group : this.groups) {
            if (!group.behaviours().containsKey(pGroupName)) continue;
            return group;
        }
        return null;
    }
}

