/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.controller;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.minecraft.CompoundTagUtils;
import software.bluelib.loader.cache.controller.AnimationCache;

public record StateCache(boolean isOverlay, @NotNull List<AnimationCache> animations) {
    @NotNull
    public static final Codec<StateCache> CODEC = Codec.PASSTHROUGH.comapFlatMap(dynamic -> {
        CompoundTag tag = (CompoundTag)dynamic.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        return DataResult.success((Object)StateCache.readFromNBT(tag));
    }, stateCache -> {
        CompoundTag tag = new CompoundTag();
        stateCache.writeToNBT(tag);
        return new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)tag);
    });
    @NotNull
    public static final DataComponentType<StateCache> STATE_CACHE_DATA = DataComponentType.builder().persistent(CODEC).build();

    public void writeToNBT(@NotNull CompoundTag pTag) {
        pTag.putBoolean("isOverlay", this.isOverlay);
        CompoundTagUtils.writeList(pTag, "animations", this.animations, (tag, data) -> data.writeToNBT((CompoundTag)tag));
    }

    @NotNull
    public static StateCache readFromNBT(@NotNull CompoundTag pTag) {
        boolean isOverlay = pTag.getBoolean("isOverlay");
        List<AnimationCache> animations = CompoundTagUtils.readList(pTag, "animations", AnimationCache::readFromNBT);
        return new StateCache(isOverlay, animations);
    }
}

