/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.item;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public final class IdCache
extends SavedData {
    @NotNull
    private static final SavedData.Factory<IdCache> FACTORY = new SavedData.Factory(IdCache::new, IdCache::new, null);
    @NotNull
    private static final String DATA_KEY = "bluelib_id_cache";
    private long lastId;

    private IdCache() {
    }

    private IdCache(@NotNull CompoundTag pTag, @NotNull HolderLookup.Provider pRegistryLookup) {
        this.lastId = pTag.getLong("last_id");
    }

    public static long getFreeId(@NotNull ServerLevel pLevel) {
        return IdCache.getCache(pLevel).getNextId();
    }

    private long getNextId() {
        this.setDirty();
        return ++this.lastId;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag pTag, @NotNull // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull @NotNull HolderLookup.Provider pRegistryLookup) {
        pTag.putLong("last_id", this.lastId);
        return pTag;
    }

    @NotNull
    private static IdCache getCache(@NotNull ServerLevel pLevel) {
        return (IdCache)pLevel.getServer().overworld().getDataStorage().computeIfAbsent(FACTORY, DATA_KEY);
    }
}

