/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.texture;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.util.FastColor;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record GlowingTextureMeta(@NotNull List<Pixel> pixels) {
    @NotNull
    public static final MetadataSectionSerializer<GlowingTextureMeta> DESERIALIZER = new MetadataSectionSerializer<GlowingTextureMeta>(){

        @NotNull
        public String getMetadataSectionName() {
            return "glowsections";
        }

        @NotNull
        public GlowingTextureMeta fromJson(@NotNull JsonObject pJson) {
            List<Pixel> pixels = this.fromSections(GsonHelper.getAsJsonArray((JsonObject)pJson, (String)"sections", null));
            if (pixels.isEmpty()) {
                throw new JsonParseException("Empty glowlayer sections file. Must have at least one glow section!");
            }
            return new GlowingTextureMeta(pixels);
        }

        @NotNull
        private List<Pixel> fromSections(@Nullable JsonArray pSectionsArray) {
            if (pSectionsArray == null) {
                return List.of();
            }
            ObjectArrayList pixels = new ObjectArrayList();
            for (JsonElement pElement : pSectionsArray) {
                if (!(pElement instanceof JsonObject)) {
                    throw new JsonParseException("Invalid glowsections json format, expected a JsonObject, found: " + String.valueOf(pElement.getClass()));
                }
                JsonObject obj = (JsonObject)pElement;
                int x1 = GsonHelper.getAsInt((JsonObject)obj, (String)"x1", (int)GsonHelper.getAsInt((JsonObject)obj, (String)"x", (int)0));
                int y1 = GsonHelper.getAsInt((JsonObject)obj, (String)"y1", (int)GsonHelper.getAsInt((JsonObject)obj, (String)"y", (int)0));
                int x2 = GsonHelper.getAsInt((JsonObject)obj, (String)"x2", (int)(GsonHelper.getAsInt((JsonObject)obj, (String)"w", (int)0) + x1));
                int y2 = GsonHelper.getAsInt((JsonObject)obj, (String)"y2", (int)(GsonHelper.getAsInt((JsonObject)obj, (String)"h", (int)0) + y1));
                int alpha = GsonHelper.getAsInt((JsonObject)obj, (String)"alpha", (int)GsonHelper.getAsInt((JsonObject)obj, (String)"a", (int)0));
                if (x1 + y1 + x2 + y2 == 0) {
                    throw new IllegalArgumentException("Invalid glowsections section object, section must be at least one pixel in size");
                }
                for (int x = x1; x <= x2; ++x) {
                    for (int y = y1; y <= y2; ++y) {
                        pixels.add(new Pixel(x, y, alpha));
                    }
                }
            }
            return pixels;
        }
    };

    @NotNull
    public static GlowingTextureMeta fromExistingImage(@NotNull NativeImage pGlowLayer) {
        ObjectArrayList pixels = new ObjectArrayList();
        for (int x = 0; x < pGlowLayer.getWidth(); ++x) {
            for (int y = 0; y < pGlowLayer.getHeight(); ++y) {
                int color = pGlowLayer.getPixelRGBA(x, y);
                if (color == 0) continue;
                pixels.add(new Pixel(x, y, FastColor.ABGR32.alpha((int)color)));
            }
        }
        if (pixels.isEmpty()) {
            throw new IllegalStateException("Invalid glow layer texture provided, must have at least one pixel!");
        }
        return new GlowingTextureMeta((List<Pixel>)pixels);
    }

    public void createImageMask(@NotNull NativeImage pOriginalImage, @NotNull NativeImage pNewImage) {
        for (Pixel pixel : this.pixels) {
            int color = pOriginalImage.getPixelRGBA(pixel.x.intValue(), pixel.y.intValue());
            if (pixel.alpha > 0) {
                color = FastColor.ABGR32.color((int)pixel.alpha, (int)FastColor.ABGR32.blue((int)color), (int)FastColor.ABGR32.green((int)color), (int)FastColor.ABGR32.red((int)color));
            }
            pNewImage.setPixelRGBA(pixel.x.intValue(), pixel.y.intValue(), color);
            pOriginalImage.setPixelRGBA(pixel.x.intValue(), pixel.y.intValue(), 0);
        }
    }

    public record Pixel(@NotNull Integer x, @NotNull Integer y, @NotNull Integer alpha) {
    }
}

