/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.deserialize.controller;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.loader.JsonUtils;
import software.bluelib.loader.json.deserialize.controller.State;

public record Behaviour(@NotNull List<String> conditions, @Nullable Integer priority, @NotNull Map<String, State> states) {
    @NotNull
    public static JsonDeserializer<Behaviour> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            List<String> conditions = JsonUtils.jsonArrayToStringList(GsonHelper.getAsJsonArray((JsonObject)obj, (String)"conditions"));
            Integer priority = JsonUtils.getOptionalInteger(obj, "priority");
            JsonObject statesObj = JsonUtils.filterJsonObject(obj, "conditions", "priority");
            Map<String, State> states = JsonUtils.jsonObjToMap(statesObj, context, State.class);
            return new Behaviour(conditions, priority, states);
        };
    }
}

