/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.deserialize.model;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.loader.JsonUtils;

public record LocatorClass(@Nullable Boolean ignoreInheritedScale, @NotNull List<Float> offset, @NotNull List<Float> rotation) {
    @NotNull
    public static JsonDeserializer<LocatorClass> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            Boolean ignoreInheritedScale = JsonUtils.getOptionalBoolean(obj, "ignore_inherited_scale");
            List<Float> offset = JsonUtils.jsonArrayToFloatList(JsonUtils.getOptionalJsonArray(obj, "offset"));
            List<Float> rotation = JsonUtils.jsonArrayToFloatList(JsonUtils.getOptionalJsonArray(obj, "rotation"));
            return new LocatorClass(ignoreInheritedScale, offset, rotation);
        };
    }
}

