/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.exception.nulls.EntityNullException;
import software.bluelib.api.exception.nulls.EquipmentSlotNullException;
import software.bluelib.api.exception.nulls.ItemStackNullException;
import software.bluelib.api.exception.nulls.ModelNullException;
import software.bluelib.api.utils.Color;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animatable.item.BlueItem;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.model.ModelCache;
import software.bluelib.loader.cache.texture.AnimatableTexture;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderLayersContainer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;

public class BlueArmorRenderer<T extends Item, L extends LivingEntity>
extends HumanoidModel<L>
implements BlueRenderer<T> {
    @NotNull
    protected final BlueRenderLayersContainer<T> renderLayers = new BlueRenderLayersContainer(this);
    @NotNull
    protected final BlueModel<T> model;
    @Nullable
    protected T animatable;
    @Nullable
    protected HumanoidModel<?> baseModel;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    @NotNull
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    @NotNull
    protected Matrix4f modelRenderTranslations = new Matrix4f();
    @Nullable
    protected ModelCache lastModel = null;
    @Nullable
    protected BoneCache head = null;
    @Nullable
    protected BoneCache body = null;
    @Nullable
    protected BoneCache rightArm = null;
    @Nullable
    protected BoneCache leftArm = null;
    @Nullable
    protected BoneCache rightLeg = null;
    @Nullable
    protected BoneCache leftLeg = null;
    @Nullable
    protected BoneCache rightBoot = null;
    @Nullable
    protected BoneCache leftBoot = null;
    @Nullable
    protected Entity currentEntity = null;
    @Nullable
    protected ItemStack currentStack = null;
    @Nullable
    protected EquipmentSlot currentSlot = null;
    @Nullable
    protected MultiBufferSource bufferSource = null;
    protected float partialTick;
    protected float limbSwing;
    protected float limbSwingAmount;
    protected float netHeadYaw;
    protected float headPitch;

    public BlueArmorRenderer(@NotNull BlueModel<T> pModel) {
        super(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER_INNER_ARMOR));
        this.model = pModel;
        this.young = false;
    }

    @Override
    @NotNull
    public BlueModel<T> getBlueModel() {
        return this.model;
    }

    @Override
    @Nullable
    public T getOptionalAnimatable() {
        return this.animatable;
    }

    @Nullable
    public HumanoidModel<?> getOptionalBaseModel() {
        return this.baseModel;
    }

    @NotNull
    public HumanoidModel<?> getBaseModel() {
        HumanoidModel<?> baseModel = this.getOptionalBaseModel();
        if (baseModel == null) {
            throw new ModelNullException("baseModel cannot be null when rendering!");
        }
        return baseModel;
    }

    @Nullable
    public Entity getOptionalCurrentEntity() {
        return this.currentEntity;
    }

    @NotNull
    public Entity getCurrentEntity() {
        Entity currentEntity = this.getOptionalCurrentEntity();
        if (currentEntity == null) {
            throw new EntityNullException("currentEntity cannot be null when rendering!");
        }
        return currentEntity;
    }

    @Nullable
    public ItemStack getOptionalCurrentStack() {
        return this.currentStack;
    }

    @NotNull
    public ItemStack getCurrentStack() {
        ItemStack currentStack = this.getOptionalCurrentStack();
        if (currentStack == null) {
            throw new ItemStackNullException("currentStack cannot be null when rendering!");
        }
        return currentStack;
    }

    @Nullable
    public EquipmentSlot getOptionalCurrentSlot() {
        return this.currentSlot;
    }

    @NotNull
    public EquipmentSlot getCurrentSlot() {
        EquipmentSlot currentSlot = this.getOptionalCurrentSlot();
        if (currentSlot == null) {
            throw new EquipmentSlotNullException("currentSlot cannot be null when rendering!");
        }
        return currentSlot;
    }

    @Override
    public long getInstanceId(@NotNull IRenderContext<T> pContext) {
        if (this.currentStack == null) {
            return (long)Math.pow(this.getCurrentEntity().getId(), 7.0) * (long)(-(this.getCurrentSlot().ordinal() + 1));
        }
        long stackId = BlueItem.getId(this.currentStack);
        if (stackId == Long.MAX_VALUE) {
            return (long)Math.pow(this.getCurrentEntity().getId(), 7.0) * (long)(-(this.getCurrentSlot().ordinal() + 1));
        }
        return -stackId;
    }

    @Override
    @NotNull
    public RenderType getRenderType(@NotNull ResourceLocation pTexture, @NotNull IRenderContext<T> pContext) {
        return RenderType.armorCutoutNoCull((ResourceLocation)pTexture);
    }

    @Override
    @NotNull
    public List<BlueRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    @NotNull
    public BlueArmorRenderer<T, L> addRenderLayer(@NotNull BlueRenderLayer<T> pRenderLayer) {
        this.renderLayers.addLayer(pRenderLayer);
        return this;
    }

    @NotNull
    public BlueArmorRenderer<T, L> withScale(float pScale) {
        return this.withScale(pScale, pScale);
    }

    @NotNull
    public BlueArmorRenderer<T, L> withScale(float pScaleWidth, float pScaleHeight) {
        this.scaleWidth = pScaleWidth;
        this.scaleHeight = pScaleHeight;
        return this;
    }

    @Nullable
    public BoneCache getBoneByName(@NotNull BlueModel<T> pModel, @NotNull String pBoneName) {
        return pModel.getBone(pBoneName).orElse(null);
    }

    @Nullable
    public BoneCache getHeadBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorHead");
    }

    @Nullable
    public BoneCache getBodyBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorBody");
    }

    @Nullable
    public BoneCache getRightArmBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorRightArm");
    }

    @Nullable
    public BoneCache getLeftArmBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorLeftArm");
    }

    @Nullable
    public BoneCache getRightLegBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorRightLeg");
    }

    @Nullable
    public BoneCache getLeftLegBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorLeftLeg");
    }

    @Nullable
    public BoneCache getRightBootBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorRightBoot");
    }

    @Nullable
    public BoneCache getLeftBootBone(@NotNull BlueModel<T> pModel) {
        return this.getBoneByName(pModel, "armorLeftBoot");
    }

    @Override
    @NotNull
    public Color getRenderColor(@NotNull T pAnimatable, float pPartialTick, int pPackedLight) {
        return this.getCurrentStack().is(ItemTags.DYEABLE) ? Color.ofOpaque(DyedItemColor.getOrDefault((ItemStack)this.getCurrentStack(), (int)-6265536)) : Color.WHITE;
    }

    @Override
    public void preRender(@NotNull IRenderContext<T> pContext) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
        this.applyBaseModel(this.getBaseModel());
        this.grabRelevantBones(pContext.model());
        this.applyBaseTransformations(this.getBaseModel());
        this.scaleModelForBaby(pContext);
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, pContext);
        if (!(this.getCurrentEntity() instanceof BlueAnimatable)) {
            this.applyBoneVisibilityBySlot(this.getCurrentSlot());
        }
    }

    @ApiStatus.Internal
    public void renderToBuffer(@NotNull PoseStack pPoseStack, @Nullable VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        Minecraft mc = Minecraft.getInstance();
        MultiBufferSource.BufferSource pBufferSource = mc.levelRenderer.renderBuffers.bufferSource();
        if (mc.levelRenderer.shouldShowEntityOutlines() && mc.shouldEntityAppearGlowing(this.getCurrentEntity())) {
            pBufferSource = mc.levelRenderer.renderBuffers.outlineBufferSource();
        }
        float pPartialTick = mc.getTimer().getGameTimeDeltaPartialTick(true);
        RenderType pRenderType = this.getRenderType(this.getTextureLocation((BlueAnimatable)((Item)this.getAnimatable())), new BaseRenderContext<Item>(pPoseStack, (Item)this.getAnimatable(), this.model.getBakedModel(this.getBlueModel().getModelResource((Item)this.getAnimatable(), this)), (MultiBufferSource)pBufferSource, false, pPartialTick, pPackedLight, pPackedOverlay, pColor));
        pBuffer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)pBufferSource, (RenderType)pRenderType, (boolean)this.getCurrentStack().hasFoil());
        this.defaultRender(new FullRenderContext<Item>(pPoseStack, (Item)this.getAnimatable(), this.model.getBakedModel(this.getBlueModel().getModelResource((Item)this.getAnimatable(), this)), pRenderType, (MultiBufferSource)pBufferSource, pBuffer, false, pPartialTick, pPackedLight, this.getPackedOverlay((BlueAnimatable)((Item)this.getAnimatable()), 0.0f, pPartialTick), this.getRenderColor((Item)this.getAnimatable(), pPartialTick, pPackedLight).argbInt()));
        this.animatable = null;
    }

    @Override
    public void actuallyRender(@NotNull IRenderContext<T> pContext) {
        if (pContext instanceof FullRenderContext) {
            FullRenderContext full = (FullRenderContext)pContext;
            PoseStack pPoseStack = full.poseStack();
            Item pAnimatable = (Item)full.animatable();
            VertexConsumer pBuffer = full.optionalBuffer();
            boolean pIsReRender = full.isReRender();
            float pPartialTick = full.partialTick();
            pPoseStack.pushPose();
            pPoseStack.translate(0.0f, 1.5f, 0.0f);
            pPoseStack.scale(-1.0f, -1.0f, 1.0f);
            if (!pIsReRender) {
                AnimationState<Item> animationState = new AnimationState<Item>(pAnimatable, 0.0f, 0.0f, pPartialTick, false);
                long instanceId = this.getInstanceId(pContext);
                BlueModel<Item> currentModel = this.getBlueModel();
                animationState.setData(DataTickets.TICK, ((BlueItem)pAnimatable).getTick(this.getCurrentEntity()));
                animationState.setData(DataTickets.ITEMSTACK, this.currentStack);
                animationState.setData(DataTickets.ENTITY, this.getCurrentEntity());
                animationState.setData(DataTickets.EQUIPMENT_SLOT, this.currentSlot);
                currentModel.addAdditionalStateData(pAnimatable, instanceId, (x$0, x$1) -> animationState.setData(x$0, x$1));
                currentModel.handleAnimations(pAnimatable, instanceId, animationState, pPartialTick);
            }
            this.modelRenderTranslations = new Matrix4f((Matrix4fc)pPoseStack.last().pose());
            if (pBuffer != null) {
                BlueRenderer.super.actuallyRender(full);
            }
            pPoseStack.popPose();
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            this.handleBaseActuallyRenderContext(base, this);
        }
    }

    @Override
    public void doPostRenderCleanup(@NotNull IRenderContext<T> pContext) {
        this.baseModel = null;
        this.currentEntity = null;
        this.currentStack = null;
        this.animatable = null;
        this.currentSlot = null;
        this.bufferSource = null;
        this.partialTick = 0.0f;
        this.limbSwing = 0.0f;
        this.limbSwingAmount = 0.0f;
        this.netHeadYaw = 0.0f;
        this.headPitch = 0.0f;
    }

    @Override
    public void renderRecursively(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        if (pBone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
            pBone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            pBone.setLocalSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations));
        }
        BlueRenderer.super.renderRecursively(pBone, pContext);
    }

    protected void grabRelevantBones(@NotNull ModelCache pBakedModel) {
        if (this.lastModel == pBakedModel) {
            return;
        }
        BlueModel<T> pModel = this.getBlueModel();
        this.lastModel = pBakedModel;
        this.head = this.getHeadBone(pModel);
        this.body = this.getBodyBone(pModel);
        this.rightArm = this.getRightArmBone(pModel);
        this.leftArm = this.getLeftArmBone(pModel);
        this.rightLeg = this.getRightLegBone(pModel);
        this.leftLeg = this.getLeftLegBone(pModel);
        this.rightBoot = this.getRightBootBone(pModel);
        this.leftBoot = this.getLeftBootBone(pModel);
    }

    protected void applyBaseModel(@NotNull HumanoidModel<?> pBaseModel) {
        BlueArmorRenderer self = this;
        self.young = pBaseModel.young;
        self.crouching = pBaseModel.crouching;
        self.riding = pBaseModel.riding;
        self.rightArmPose = pBaseModel.rightArmPose;
        self.leftArmPose = pBaseModel.leftArmPose;
        this.copyVisibility(self, pBaseModel);
    }

    protected void copyVisibility(@NotNull HumanoidModel<?> pTarget, @NotNull HumanoidModel<?> pSource) {
        pTarget.head.visible = pSource.head.visible;
        pTarget.hat.visible = pSource.hat.visible;
        pTarget.body.visible = pSource.body.visible;
        pTarget.rightArm.visible = pSource.rightArm.visible;
        pTarget.leftArm.visible = pSource.leftArm.visible;
        pTarget.rightLeg.visible = pSource.rightLeg.visible;
        pTarget.leftLeg.visible = pSource.leftLeg.visible;
    }

    protected void applyBoneVisibilityBySlot(@NotNull EquipmentSlot pCurrentSlot) {
        record BoneVisibility(@Nullable BoneCache bone, boolean visible) {
        }
        BoneVisibility[] visibilities;
        BoneVisibility[] boneVisibilityArray;
        this.setAllBonesVisible(false);
        BlueArmorRenderer pModel = this;
        switch (pCurrentSlot) {
            case HEAD: {
                BoneVisibility[] boneVisibilityArray2 = new BoneVisibility[1];
                boneVisibilityArray = boneVisibilityArray2;
                boneVisibilityArray2[0] = new BoneVisibility(this.head, ((HumanoidModel)pModel).head.visible);
                break;
            }
            case CHEST: {
                BoneVisibility[] boneVisibilityArray3 = new BoneVisibility[3];
                boneVisibilityArray3[0] = new BoneVisibility(this.body, ((HumanoidModel)pModel).body.visible);
                boneVisibilityArray3[1] = new BoneVisibility(this.rightArm, ((HumanoidModel)pModel).rightArm.visible);
                boneVisibilityArray = boneVisibilityArray3;
                boneVisibilityArray3[2] = new BoneVisibility(this.leftArm, ((HumanoidModel)pModel).leftArm.visible);
                break;
            }
            case LEGS: {
                BoneVisibility[] boneVisibilityArray4 = new BoneVisibility[2];
                boneVisibilityArray4[0] = new BoneVisibility(this.rightLeg, ((HumanoidModel)pModel).rightLeg.visible);
                boneVisibilityArray = boneVisibilityArray4;
                boneVisibilityArray4[1] = new BoneVisibility(this.leftLeg, ((HumanoidModel)pModel).leftLeg.visible);
                break;
            }
            case FEET: {
                BoneVisibility[] boneVisibilityArray5 = new BoneVisibility[2];
                boneVisibilityArray5[0] = new BoneVisibility(this.rightBoot, ((HumanoidModel)pModel).rightLeg.visible);
                boneVisibilityArray = boneVisibilityArray5;
                boneVisibilityArray5[1] = new BoneVisibility(this.leftBoot, ((HumanoidModel)pModel).leftLeg.visible);
                break;
            }
            default: {
                boneVisibilityArray = new BoneVisibility[]{};
            }
        }
        for (BoneVisibility visibility : visibilities = boneVisibilityArray) {
            this.setBoneVisible(visibility.bone(), visibility.visible());
        }
    }

    public void applyBoneVisibilityByPart(@NotNull EquipmentSlot pCurrentSlot, @NotNull ModelPart pCurrentPart, @NotNull HumanoidModel<?> pModel) {
        this.setAllVisible(false);
        pCurrentPart.visible = true;
        BoneCache bone = null;
        if (pCurrentPart == pModel.hat || pCurrentPart == pModel.head) {
            bone = this.head;
        } else if (pCurrentPart == pModel.body) {
            bone = this.body;
        } else if (pCurrentPart == pModel.leftArm) {
            bone = this.leftArm;
        } else if (pCurrentPart == pModel.rightArm) {
            bone = this.rightArm;
        } else if (pCurrentPart == pModel.leftLeg) {
            bone = pCurrentSlot == EquipmentSlot.FEET ? this.leftBoot : this.leftLeg;
        } else if (pCurrentPart == pModel.rightLeg) {
            BoneCache boneCache = bone = pCurrentSlot == EquipmentSlot.FEET ? this.rightBoot : this.rightLeg;
        }
        if (bone != null) {
            bone.setHidden(false);
        }
    }

    protected void applyBaseTransformations(@NotNull HumanoidModel<?> pBaseModel) {
        record TransformData(@Nullable BoneCache bone, ModelPart part, float xOffset, float yOffset, float zOffset) {
        }
        TransformData[] transforms;
        for (TransformData t : transforms = new TransformData[]{new TransformData(this.head, pBaseModel.head, 0.0f, 0.0f, 0.0f), new TransformData(this.body, pBaseModel.body, 0.0f, 0.0f, 0.0f), new TransformData(this.rightArm, pBaseModel.rightArm, 5.0f, 2.0f, 0.0f), new TransformData(this.leftArm, pBaseModel.leftArm, -5.0f, 2.0f, 0.0f), new TransformData(this.rightLeg, pBaseModel.rightLeg, 2.0f, 12.0f, 0.0f), new TransformData(this.leftLeg, pBaseModel.leftLeg, -2.0f, 12.0f, 0.0f)}) {
            if (t.bone() == null) continue;
            RenderUtils.matchModelPartRot(t.part(), t.bone());
            t.bone().updatePosition(t.part().x + t.xOffset, t.yOffset - t.part().y, t.part().z + t.zOffset);
        }
        if (this.rightBoot != null && this.rightLeg != null) {
            ModelPart rightLegPart = pBaseModel.rightLeg;
            RenderUtils.matchModelPartRot(rightLegPart, this.rightBoot);
            this.rightBoot.updatePosition(rightLegPart.x + 2.0f, 12.0f - rightLegPart.y, rightLegPart.z);
        }
        if (this.leftBoot != null && this.leftLeg != null) {
            ModelPart leftLegPart = pBaseModel.leftLeg;
            RenderUtils.matchModelPartRot(leftLegPart, this.leftBoot);
            this.leftBoot.updatePosition(leftLegPart.x - 2.0f, 12.0f - leftLegPart.y, leftLegPart.z);
        }
    }

    public void setAllVisible(boolean pVisible) {
        super.setAllVisible(pVisible);
        this.setAllBonesVisible(pVisible);
    }

    protected void setAllBonesVisible(boolean pVisible) {
        this.setBoneVisible(this.head, pVisible);
        this.setBoneVisible(this.body, pVisible);
        this.setBoneVisible(this.rightArm, pVisible);
        this.setBoneVisible(this.leftArm, pVisible);
        this.setBoneVisible(this.rightLeg, pVisible);
        this.setBoneVisible(this.leftLeg, pVisible);
        this.setBoneVisible(this.rightBoot, pVisible);
        this.setBoneVisible(this.leftBoot, pVisible);
    }

    public void scaleModelForBaby(@NotNull IRenderContext<T> pContext) {
        if (!this.young || pContext.isReRender()) {
            return;
        }
        if (this.currentSlot == EquipmentSlot.HEAD) {
            if (this.getBaseModel().scaleHead) {
                float headScale = 1.5f / this.getBaseModel().babyHeadScale;
                pContext.poseStack().scale(headScale, headScale, headScale);
            }
            pContext.poseStack().translate(0.0f, this.getBaseModel().babyYHeadOffset / 16.0f, this.getBaseModel().babyZHeadOffset / 16.0f);
        } else {
            float bodyScale = 1.0f / this.getBaseModel().babyBodyScale;
            pContext.poseStack().scale(bodyScale, bodyScale, bodyScale);
            pContext.poseStack().translate(0.0f, this.getBaseModel().bodyYOffset / 16.0f, 0.0f);
        }
    }

    protected void setBoneVisible(@Nullable BoneCache pBone, boolean pVisible) {
        if (pBone == null) {
            return;
        }
        pBone.setHidden(!pVisible);
    }

    @Override
    public void updateAnimatedTextureFrame(@NotNull IRenderContext<T> pContext) {
        if (this.getOptionalCurrentEntity() != null) {
            AnimatableTexture.setAndUpdate(this.getTextureLocation((BlueAnimatable)((Item)pContext.animatable())));
        }
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireCompileArmorRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(@NotNull IRenderContext<T> pContext) {
        return BlueLibConstants.PlatformHelper.EVENT_PROXY.fireArmorPreRender(this, pContext);
    }

    @Override
    public void firePostRenderEvent(@NotNull IRenderContext<T> pContext) {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireArmorPostRender(this, pContext);
    }
}

