/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.base;

import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.model.ModelCache;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.IRenderContext;

public abstract class BlueRenderLayer<T extends BlueAnimatable> {
    @NotNull
    protected final BlueRenderer<T> renderer;

    public BlueRenderLayer(@NotNull BlueRenderer<T> pEntityRenderer) {
        this.renderer = pEntityRenderer;
    }

    @NotNull
    public BlueModel<T> getBlueModel() {
        return this.renderer.getBlueModel();
    }

    @NotNull
    public ModelCache getDefaultBakedModel(@NotNull T pAnimatable) {
        return this.getBlueModel().getBakedModel(this.getBlueModel().getModelResource(pAnimatable, this.getRenderer()));
    }

    @NotNull
    public BlueRenderer<T> getRenderer() {
        return this.renderer;
    }

    @NotNull
    protected ResourceLocation getTextureResource(@NotNull T pAnimatable) {
        return this.getRenderer().getTextureLocation(pAnimatable);
    }

    public void preRender(@NotNull IRenderContext<T> pContext) {
    }

    public void render(@NotNull IRenderContext<T> pContext) {
    }

    public void renderForBone(@NotNull BoneCache pBone, @NotNull IRenderContext<T> pContext) {
    }
}

