/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.exception.nulls.EntityNullException;
import software.bluelib.api.utils.loader.BufferUtils;
import software.bluelib.client.utils.PlayerUtils;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.texture.AnimatableTexture;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.geckolib.constant.dataticket.DataTicket;
import software.bluelib.loader.geckolib.data.EntityModelData;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderLayersContainer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;
import software.bluelib.loader.renderer.entity.EntityRenderUtils;

public class BlueReplacedEntityRenderer<E extends Entity, T extends BlueAnimatable>
extends EntityRenderer<E>
implements BlueRenderer<T> {
    @NotNull
    protected final BlueRenderLayersContainer<T> renderLayers = new BlueRenderLayersContainer(this);
    @NotNull
    protected final BlueModel<T> model;
    @NotNull
    protected final T animatable;
    @Nullable
    protected E currentEntity;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    @NotNull
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    @NotNull
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public BlueReplacedEntityRenderer(@NotNull EntityRendererProvider.Context pRenderManager, @NotNull BlueModel<T> pModel, @NotNull T pAnimatable) {
        super(pRenderManager);
        this.model = pModel;
        this.animatable = pAnimatable;
    }

    @Override
    @NotNull
    public BlueModel<T> getBlueModel() {
        return this.model;
    }

    @Override
    @NotNull
    public T getOptionalAnimatable() {
        return this.getAnimatable();
    }

    @Override
    @NotNull
    public T getAnimatable() {
        return this.animatable;
    }

    @Nullable
    public E getOptionalCurrentEntity() {
        return this.currentEntity;
    }

    @NotNull
    public E getCurrentEntity() {
        E currentEntity = this.getOptionalCurrentEntity();
        if (currentEntity == null) {
            throw new EntityNullException("currentEntity cannot be null when rendering!");
        }
        return currentEntity;
    }

    @Override
    public long getInstanceId(@NotNull IRenderContext<T> pContext) {
        return this.getCurrentEntity().getId();
    }

    @Override
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull E pEntity) {
        return BlueRenderer.super.getTextureLocation(this.getAnimatable());
    }

    @Override
    @NotNull
    public List<BlueRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    @NotNull
    public BlueReplacedEntityRenderer<E, T> addRenderLayer(@NotNull BlueRenderLayer<T> pRenderLayer) {
        this.renderLayers.addLayer(pRenderLayer);
        return this;
    }

    @NotNull
    public BlueReplacedEntityRenderer<E, T> withScale(float pScale) {
        return this.withScale(pScale, pScale);
    }

    @NotNull
    public BlueReplacedEntityRenderer<E, T> withScale(float pScaleWidth, float pScaleHeight) {
        this.scaleWidth = pScaleWidth;
        this.scaleHeight = pScaleHeight;
        return this;
    }

    @Override
    @Nullable
    public RenderType getRenderType(@NotNull ResourceLocation pTexture, @NotNull IRenderContext<T> pContext) {
        boolean invisible;
        boolean bl = invisible = this.currentEntity != null && this.currentEntity.isInvisible();
        if (invisible && !this.currentEntity.isInvisibleTo(PlayerUtils.getClientPlayer())) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)pTexture);
        }
        if (!invisible) {
            return BlueRenderer.super.getRenderType(pTexture, pContext);
        }
        return this.currentEntity != null && Minecraft.getInstance().shouldEntityAppearGlowing(this.currentEntity) ? RenderType.outline((ResourceLocation)pTexture) : null;
    }

    @Override
    public void preRender(@NotNull IRenderContext<T> pContext) {
        this.entityRenderTranslations = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, pContext);
    }

    @ApiStatus.Internal
    public void render(@NotNull E pEntity, float pEntityYaw, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight) {
        this.currentEntity = pEntity;
        this.defaultRender(new BaseRenderContext<T>(pPoseStack, this.getAnimatable(), this.model.getBakedModel(this.getBlueModel().getModelResource(this.animatable, this)), pBufferSource, false, pPartialTick, pPackedLight, this.getPackedOverlay(this.getAnimatable(), 0.0f, pPartialTick), this.getRenderColor((BlueAnimatable)this.getAnimatable(), pPartialTick, pPackedLight).argbInt()));
    }

    @Override
    public void actuallyRender(@NotNull IRenderContext<T> pContext) {
        if (pContext instanceof FullRenderContext) {
            float[] fArray;
            LivingEntity e;
            FullRenderContext full = (FullRenderContext)pContext;
            PoseStack poseStack = full.poseStack();
            Object animatable = full.animatable();
            VertexConsumer buffer = full.optionalBuffer();
            boolean isReRender = full.isReRender();
            float partialTick = full.partialTick();
            poseStack.pushPose();
            E e2 = this.currentEntity;
            LivingEntity livingEntity = e2 instanceof LivingEntity ? (e = (LivingEntity)e2) : null;
            e2 = this.currentEntity;
            if (e2 instanceof Mob) {
                Entity leashHolder;
                Mob mob = (Mob)e2;
                if (!isReRender && (leashHolder = mob.getLeashHolder()) != null) {
                    this.renderLeash(mob, partialTick, poseStack, full.bufferSource(), leashHolder);
                }
            }
            boolean shouldSit = this.getCurrentEntity().isPassenger() && this.getCurrentEntity().getVehicle() != null;
            float lerpBodyRot = EntityRenderUtils.getLerpBodyRot(livingEntity, partialTick);
            float lerpHeadRot = EntityRenderUtils.getLerpHeadRot(livingEntity, partialTick);
            float[] adjusted = EntityRenderUtils.adjustSittingRotations(shouldSit, this.getCurrentEntity(), lerpHeadRot, lerpBodyRot, partialTick);
            lerpBodyRot = adjusted[0];
            float netHeadYaw = adjusted[1];
            if (livingEntity != null) {
                EntityRenderUtils.applySleepingTranslation(poseStack, livingEntity);
            }
            float nativeScale = livingEntity != null ? livingEntity.getScale() : 1.0f;
            float ageInTicks = (float)((Entity)this.getCurrentEntity()).tickCount + partialTick;
            poseStack.scale(nativeScale, nativeScale, nativeScale);
            this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick, nativeScale);
            if (livingEntity != null) {
                fArray = EntityRenderUtils.computeLimbSwing(livingEntity, shouldSit, partialTick);
            } else {
                float[] fArray2 = new float[2];
                fArray2[0] = 0.0f;
                fArray = fArray2;
                fArray2[1] = 0.0f;
            }
            float[] limbSwingData = fArray;
            float limbSwing = limbSwingData[0];
            float limbSwingAmount = limbSwingData[1];
            float headPitch = Mth.lerp((float)partialTick, (float)((Entity)this.getCurrentEntity()).xRotO, (float)this.getCurrentEntity().getXRot());
            if (!isReRender) {
                float motionThreshold = this.getMotionAnimThreshold(pContext);
                boolean moving = livingEntity != null ? EntityRenderUtils.isEntityMoving(livingEntity, motionThreshold, limbSwingAmount) : Math.abs(limbSwingAmount) >= motionThreshold;
                AnimationState state = new AnimationState(animatable, limbSwing, limbSwingAmount, partialTick, moving);
                long instanceId = this.getInstanceId(pContext);
                BlueModel<BlueAnimatable> model = this.getBlueModel();
                state.setData(DataTickets.TICK, animatable.getTick(this.getCurrentEntity()));
                state.setData(DataTickets.ENTITY, this.getCurrentEntity());
                state.setData(DataTickets.ENTITY_MODEL_DATA, new EntityModelData(shouldSit, livingEntity != null && livingEntity.isBaby(), -netHeadYaw, -headPitch));
                model.addAdditionalStateData((BlueAnimatable)animatable, instanceId, (BiConsumer<DataTicket<BlueAnimatable>, BlueAnimatable>)((BiConsumer<DataTicket, BlueAnimatable>)state::setData));
                model.handleAnimations((BlueAnimatable)animatable, instanceId, state, partialTick);
            }
            poseStack.translate(0.0f, 0.01f, 0.0f);
            this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.last().pose());
            if (buffer != null) {
                BlueRenderer.super.actuallyRender(full);
            }
            poseStack.popPose();
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            this.handleBaseActuallyRenderContext(base, this);
        }
    }

    @Override
    public void applyRenderLayers(@NotNull IRenderContext<T> pContext) {
        if (!this.getCurrentEntity().isSpectator()) {
            BlueRenderer.super.applyRenderLayers(pContext);
        }
    }

    @Override
    public void renderFinal(@NotNull IRenderContext<T> pContext) {
        Mob mob;
        Entity leashHolder;
        super.render(this.getCurrentEntity(), 0.0f, pContext.partialTick(), pContext.poseStack(), pContext.bufferSource(), pContext.packedLight());
        E e = this.currentEntity;
        if (e instanceof Mob && (leashHolder = (mob = (Mob)e).getLeashHolder()) != null) {
            this.renderLeash(mob, pContext.partialTick(), pContext.poseStack(), pContext.bufferSource(), leashHolder);
        }
    }

    @Override
    public void postRender(@NotNull IRenderContext<T> pContext) {
        if (!pContext.isReRender()) {
            super.render(this.getCurrentEntity(), 0.0f, pContext.partialTick(), pContext.poseStack(), pContext.bufferSource(), pContext.packedLight());
        }
    }

    @Override
    public void doPostRenderCleanup(@NotNull IRenderContext<T> pContext) {
        this.currentEntity = null;
    }

    @Override
    public void renderRecursively(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        pContext.poseStack().pushPose();
        RenderUtils.translateMatrixToBone(pContext.poseStack(), pBone);
        RenderUtils.translateToPivotPoint(pContext.poseStack(), pBone);
        RenderUtils.rotateMatrixAroundBone(pContext.poseStack(), pBone);
        RenderUtils.scaleMatrixForBone(pContext.poseStack(), pBone);
        if (pBone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.entityRenderTranslations);
            pBone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            pBone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.getRenderOffset((Entity)this.getCurrentEntity(), 1.0f).toVector3f()));
            pBone.setWorldSpaceMatrix(RenderUtils.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), this.getCurrentEntity().position().toVector3f()));
        }
        RenderUtils.translateAwayFromPivotPoint(pContext.poseStack(), pBone);
        pContext.setBuffer(BufferUtils.checkAndRefreshBuffer(pContext.isReRender(), pContext.buffer(), pContext.bufferSource(), pContext.renderType()));
        this.renderCubesOfBone(pBone, pContext);
        if (!pContext.isReRender()) {
            this.applyRenderLayersForBone(pBone, pContext);
        }
        this.renderChildBones(pBone, pContext);
        pContext.poseStack().popPose();
    }

    protected void applyRotations(@NotNull T pAnimatable, @NotNull PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTick, float pNativeScale) {
        E e;
        if (this.isShaking(pAnimatable)) {
            pRotationYaw += (float)(Math.cos((double)((Entity)this.getCurrentEntity()).tickCount * 3.25) * Math.PI * 0.4);
        }
        if (!this.getCurrentEntity().hasPose(Pose.SLEEPING)) {
            pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f - pRotationYaw));
        }
        if ((e = this.getCurrentEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)e;
            if (livingEntity.deathTime > 0) {
                float deathRotation = ((float)livingEntity.deathTime + pPartialTick - 1.0f) / 20.0f * 1.6f;
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(Math.min(Mth.sqrt((float)deathRotation), 1.0f) * this.getDeathMaxRotation(pAnimatable)));
            } else if (livingEntity.isAutoSpinAttack()) {
                pPoseStack.mulPose(Axis.XP.rotationDegrees(-90.0f - livingEntity.getXRot()));
                pPoseStack.mulPose(Axis.YP.rotationDegrees(((float)livingEntity.tickCount + pPartialTick) * -75.0f));
            } else if (livingEntity.hasPose(Pose.SLEEPING)) {
                Direction bedOrientation = livingEntity.getBedOrientation();
                pPoseStack.mulPose(Axis.YP.rotationDegrees(bedOrientation != null ? RenderUtils.getDirectionAngle(bedOrientation).floatValue() : pRotationYaw));
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(this.getDeathMaxRotation(pAnimatable)));
                pPoseStack.mulPose(Axis.YP.rotationDegrees(270.0f));
            } else if (LivingEntityRenderer.isEntityUpsideDown((LivingEntity)livingEntity)) {
                pPoseStack.translate(0.0f, (livingEntity.getBbHeight() + 0.1f) / pNativeScale, 0.0f);
                pPoseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            }
        }
    }

    protected float getDeathMaxRotation(@NotNull T pAnimatable) {
        return 90.0f;
    }

    public double getNameRenderCutoffDistance(@NotNull E pEntity, @NotNull T pAnimatable) {
        return pEntity.isDiscrete() ? 32.0 : 64.0;
    }

    public boolean shouldShowName(@NotNull E pEntity) {
        if (!(pEntity instanceof LivingEntity)) {
            return super.shouldShowName(pEntity);
        }
        double nameRenderCutoff = this.getNameRenderCutoffDistance(pEntity, this.getAnimatable());
        if (this.entityRenderDispatcher.distanceToSqr(pEntity) >= nameRenderCutoff * nameRenderCutoff) {
            return false;
        }
        if (!(!(pEntity instanceof Mob) || pEntity.shouldShowName() || pEntity.hasCustomName() && pEntity == this.entityRenderDispatcher.crosshairPickEntity)) {
            return false;
        }
        Minecraft minecraft = Minecraft.getInstance();
        boolean visibleToClient = !pEntity.isInvisibleTo(PlayerUtils.getClientPlayer());
        PlayerTeam entityTeam = pEntity.getTeam();
        if (entityTeam == null) {
            return Minecraft.renderNames() && pEntity != minecraft.getCameraEntity() && visibleToClient && !pEntity.isVehicle();
        }
        PlayerTeam playerTeam = PlayerUtils.getClientPlayer().getTeam();
        return switch (entityTeam.getNameTagVisibility()) {
            default -> throw new MatchException(null, null);
            case Team.Visibility.ALWAYS -> visibleToClient;
            case Team.Visibility.NEVER -> false;
            case Team.Visibility.HIDE_FOR_OTHER_TEAMS -> {
                if (playerTeam == null) {
                    yield visibleToClient;
                }
                if (entityTeam.isAlliedTo((Team)playerTeam) && (entityTeam.canSeeFriendlyInvisibles() || visibleToClient)) {
                    yield true;
                }
                yield false;
            }
            case Team.Visibility.HIDE_FOR_OWN_TEAM -> playerTeam == null ? visibleToClient : !entityTeam.isAlliedTo((Team)playerTeam) && visibleToClient;
        };
    }

    @Override
    public int getPackedOverlay(@NotNull T pAnimatable, float pU, float pPartialTick) {
        E e = this.currentEntity;
        if (!(e instanceof LivingEntity)) {
            return OverlayTexture.NO_OVERLAY;
        }
        LivingEntity entity = (LivingEntity)e;
        return OverlayTexture.pack((int)OverlayTexture.u((float)pU), (int)OverlayTexture.v((entity.hurtTime > 0 || entity.deathTime > 0 ? 1 : 0) != 0));
    }

    public boolean isShaking(@NotNull T pAnimatable) {
        return this.getCurrentEntity().isFullyFrozen();
    }

    public <H extends Entity, M extends Mob> void renderLeash(@NotNull M pMob, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, @NotNull H pLeashHolder) {
        int segment;
        double lerpBodyAngle = Mth.lerp((float)pPartialTick, (float)pMob.yBodyRotO, (float)pMob.yBodyRot) * ((float)Math.PI / 180) + 1.5707964f;
        Vec3 leashOffset = pMob.getLeashOffset(pPartialTick);
        double xAngleOffset = Math.cos(lerpBodyAngle) * leashOffset.z + Math.sin(lerpBodyAngle) * leashOffset.x;
        double zAngleOffset = Math.sin(lerpBodyAngle) * leashOffset.z - Math.cos(lerpBodyAngle) * leashOffset.x;
        double lerpOriginX = Mth.lerp((double)pPartialTick, (double)pMob.xo, (double)pMob.getX()) + xAngleOffset;
        double lerpOriginY = Mth.lerp((double)pPartialTick, (double)pMob.yo, (double)pMob.getY()) + leashOffset.y;
        double lerpOriginZ = Mth.lerp((double)pPartialTick, (double)pMob.zo, (double)pMob.getZ()) + zAngleOffset;
        Vec3 ropeGripPosition = pLeashHolder.getRopeHoldPosition(pPartialTick);
        float xDif = (float)(ropeGripPosition.x - lerpOriginX);
        float yDif = (float)(ropeGripPosition.y - lerpOriginY);
        float zDif = (float)(ropeGripPosition.z - lerpOriginZ);
        float offsetMod = Mth.invSqrt((float)(xDif * xDif + zDif * zDif)) * 0.025f / 2.0f;
        float xOffset = zDif * offsetMod;
        float zOffset = xDif * offsetMod;
        VertexConsumer vertexConsumer = pBufferSource.getBuffer(RenderType.leash());
        BlockPos entityEyePos = BlockPos.containing((Position)pMob.getEyePosition(pPartialTick));
        BlockPos holderEyePos = BlockPos.containing((Position)pLeashHolder.getEyePosition(pPartialTick));
        int entityBlockLight = this.getBlockLightLevel((Entity)pMob, entityEyePos);
        int holderBlockLight = pLeashHolder.isOnFire() ? 15 : pLeashHolder.level().getBrightness(LightLayer.BLOCK, holderEyePos);
        int entitySkyLight = pMob.level().getBrightness(LightLayer.SKY, entityEyePos);
        int holderSkyLight = pMob.level().getBrightness(LightLayer.SKY, holderEyePos);
        pPoseStack.pushPose();
        pPoseStack.translate(xAngleOffset, leashOffset.y, zAngleOffset);
        Matrix4f posMatrix = new Matrix4f((Matrix4fc)pPoseStack.last().pose());
        for (segment = 0; segment <= 24; ++segment) {
            BlueReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.025f, xOffset, zOffset, segment, false);
        }
        for (segment = 24; segment >= 0; --segment) {
            BlueReplacedEntityRenderer.renderLeashPiece(vertexConsumer, posMatrix, xDif, yDif, zDif, entityBlockLight, holderBlockLight, entitySkyLight, holderSkyLight, 0.025f, 0.0f, xOffset, zOffset, segment, true);
        }
        pPoseStack.popPose();
    }

    private static void renderLeashPiece(@NotNull VertexConsumer pBuffer, @NotNull Matrix4f pPositionMatrix, float pXDif, float pYDif, float pZDif, int pEntityBlockLight, int pHolderBlockLight, int pEntitySkyLight, int pHolderSkyLight, float pWidth, float pYOffset, float pXOffset, float pZOffset, int pSegment, boolean pIsLeashKnot) {
        float piecePosPercent = (float)pSegment / 24.0f;
        int lerpBlockLight = (int)Mth.lerp((float)piecePosPercent, (float)pEntityBlockLight, (float)pHolderBlockLight);
        int lerpSkyLight = (int)Mth.lerp((float)piecePosPercent, (float)pEntitySkyLight, (float)pHolderSkyLight);
        int pPackedLight = LightTexture.pack((int)lerpBlockLight, (int)lerpSkyLight);
        float knotColourMod = pSegment % 2 == (pIsLeashKnot ? 1 : 0) ? 0.7f : 1.0f;
        float red = 0.5f * knotColourMod;
        float green = 0.4f * knotColourMod;
        float blue = 0.3f * knotColourMod;
        float x = pXDif * piecePosPercent;
        float y = pYDif > 0.0f ? pYDif * piecePosPercent * piecePosPercent : pYDif - pYDif * (1.0f - piecePosPercent) * (1.0f - piecePosPercent);
        float z = pZDif * piecePosPercent;
        pBuffer.addVertex(pPositionMatrix, x - pXOffset, y + pYOffset, z + pZOffset).setColor(red, green, blue, 1.0f).setLight(pPackedLight);
        pBuffer.addVertex(pPositionMatrix, x + pXOffset, y + pWidth - pYOffset, z - pZOffset).setColor(red, green, blue, 1.0f).setLight(pPackedLight);
    }

    @Override
    public void updateAnimatedTextureFrame(@NotNull IRenderContext<T> pContext) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation((E)pContext.animatable()));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireCompileReplacedEntityRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(@NotNull IRenderContext<T> pContext) {
        return BlueLibConstants.PlatformHelper.EVENT_PROXY.fireReplacedEntityPreRender(this, pContext);
    }

    @Override
    public void firePostRenderEvent(@NotNull IRenderContext<T> pContext) {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireReplacedEntityPostRender(this, pContext);
    }
}

