/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.renderer.item;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.exception.nulls.ItemDisplayContextNullException;
import software.bluelib.api.exception.nulls.ItemStackNullException;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animatable.item.BlueItem;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.model.ModelCache;
import software.bluelib.loader.cache.texture.AnimatableTexture;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderLayer;
import software.bluelib.loader.renderer.base.BlueRenderLayersContainer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.context.BaseRenderContext;
import software.bluelib.loader.renderer.context.FullRenderContext;
import software.bluelib.loader.renderer.context.IRenderContext;

public class BlueItemRenderer<T extends Item>
extends BlockEntityWithoutLevelRenderer
implements BlueRenderer<T> {
    @NotNull
    protected final BlueRenderLayersContainer<T> renderLayers = new BlueRenderLayersContainer(this);
    @NotNull
    protected final BlueModel<T> model;
    @Nullable
    protected ItemStack currentItemStack;
    @Nullable
    protected ItemDisplayContext renderPerspective;
    @Nullable
    protected T animatable;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;
    protected boolean useEntityGuiLighting = false;
    @NotNull
    protected Matrix4f itemRenderTranslations = new Matrix4f();
    @NotNull
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public BlueItemRenderer(@NotNull BlueModel<T> pModel) {
        this(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels(), pModel);
    }

    public BlueItemRenderer(@NotNull BlockEntityRenderDispatcher pDispatcher, @NotNull EntityModelSet pModelSet, @NotNull BlueModel<T> pModel) {
        super(pDispatcher, pModelSet);
        this.model = pModel;
    }

    @Override
    @NotNull
    public BlueModel<T> getBlueModel() {
        return this.model;
    }

    @Override
    @Nullable
    public T getOptionalAnimatable() {
        return this.animatable;
    }

    @Nullable
    public ItemStack getOptionalCurrentItemStack() {
        return this.currentItemStack;
    }

    @NotNull
    public ItemStack getCurrentItemStack() {
        ItemStack currentItemStack = this.getOptionalCurrentItemStack();
        if (currentItemStack == null) {
            throw new ItemStackNullException("CurrentItemStack cannot be null when rendering!");
        }
        return currentItemStack;
    }

    @Nullable
    public ItemDisplayContext getOptionalRenderPerspective() {
        return this.renderPerspective;
    }

    @NotNull
    public ItemDisplayContext getRenderPerspective() {
        ItemDisplayContext renderPerspective = this.getOptionalRenderPerspective();
        if (renderPerspective == null) {
            throw new ItemDisplayContextNullException("RenderPerspective cannot be null when rendering!");
        }
        return renderPerspective;
    }

    @NotNull
    public BlueItemRenderer<T> useAlternateGuiLighting() {
        this.useEntityGuiLighting = true;
        return this;
    }

    @Override
    public long getInstanceId(@NotNull IRenderContext<T> pContext) {
        return BlueItem.getId(this.getCurrentItemStack());
    }

    @Override
    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T pAnimatable) {
        return BlueRenderer.super.getTextureLocation(pAnimatable);
    }

    @Override
    @NotNull
    public List<BlueRenderLayer<T>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    @NotNull
    public BlueItemRenderer<T> addRenderLayer(@NotNull BlueRenderLayer<T> pRenderLayer) {
        this.renderLayers.addLayer(pRenderLayer);
        return this;
    }

    @NotNull
    public BlueItemRenderer<T> withScale(float pScale) {
        return this.withScale(pScale, pScale);
    }

    @NotNull
    public BlueItemRenderer<T> withScale(float pScaleWidth, float pScaleHeight) {
        this.scaleWidth = pScaleWidth;
        this.scaleHeight = pScaleHeight;
        return this;
    }

    @Override
    public void preRender(@NotNull IRenderContext<T> pContext) {
        this.itemRenderTranslations = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, pContext);
        if (!pContext.isReRender()) {
            pContext.poseStack().translate(0.5f, 0.51f, 0.5f);
        }
    }

    @ApiStatus.Internal
    public void renderByItem(@NotNull ItemStack pStack, @NotNull ItemDisplayContext pTransformType, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        this.animatable = pStack.getItem();
        this.currentItemStack = pStack;
        this.renderPerspective = pTransformType;
        float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        if (pTransformType == ItemDisplayContext.GUI) {
            this.renderInGui(pTransformType, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, partialTick);
        } else {
            int color = this.getRenderColor((BlueAnimatable)((Item)this.getAnimatable()), partialTick, pPackedLight).argbInt();
            ModelCache modelCache = this.model.getBakedModel(this.getBlueModel().getModelResource(this.animatable, this));
            RenderType renderType = this.getRenderType(this.getTextureLocation((Item)this.getAnimatable()), new BaseRenderContext<Item>(pPoseStack, (Item)this.getAnimatable(), modelCache, pBufferSource, false, partialTick, pPackedLight, pPackedOverlay, color));
            if (renderType == null) {
                renderType = RenderType.translucent();
            }
            VertexConsumer buffer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)pBufferSource, (RenderType)renderType, (boolean)false, (this.currentItemStack != null && this.currentItemStack.hasFoil() ? 1 : 0) != 0);
            this.defaultRender(new FullRenderContext<Item>(pPoseStack, (Item)this.getAnimatable(), this.model.getBakedModel(this.getBlueModel().getModelResource(this.animatable, this)), renderType, pBufferSource, buffer, false, partialTick, pPackedLight, this.getPackedOverlay((BlueAnimatable)((Item)this.getAnimatable()), 0.0f, partialTick), color));
        }
        this.animatable = null;
    }

    protected void renderInGui(@NotNull ItemDisplayContext pTransformType, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, float pPartialTick) {
        MultiBufferSource.BufferSource bufferSource2;
        this.setupLightingForGuiRender();
        MultiBufferSource.BufferSource defaultBufferSource = pBufferSource instanceof MultiBufferSource.BufferSource ? (bufferSource2 = (MultiBufferSource.BufferSource)pBufferSource) : Minecraft.getInstance().levelRenderer.renderBuffers.bufferSource();
        int color = this.getRenderColor((BlueAnimatable)((Item)this.getAnimatable()), pPartialTick, pPackedLight).argbInt();
        ModelCache modelCache = this.model.getBakedModel(this.getBlueModel().getModelResource((Item)this.getAnimatable(), this));
        RenderType renderType = this.getRenderType(this.getTextureLocation((Item)this.getAnimatable()), new BaseRenderContext<Item>(pPoseStack, (Item)this.getAnimatable(), modelCache, (MultiBufferSource)defaultBufferSource, false, pPartialTick, pPackedLight, pPackedOverlay, color));
        if (renderType == null) {
            renderType = RenderType.translucent();
        }
        VertexConsumer buffer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)pBufferSource, (RenderType)renderType, (boolean)true, (this.currentItemStack != null && this.currentItemStack.hasFoil() ? 1 : 0) != 0);
        pPoseStack.pushPose();
        this.defaultRender(new FullRenderContext<Item>(pPoseStack, (Item)this.getAnimatable(), modelCache, renderType, pBufferSource, buffer, false, pPartialTick, pPackedLight, pPackedOverlay, color));
        defaultBufferSource.endBatch();
        RenderSystem.enableDepthTest();
        Lighting.setupFor3DItems();
        pPoseStack.popPose();
    }

    @Override
    public void actuallyRender(@NotNull IRenderContext<T> pContext) {
        if (pContext instanceof FullRenderContext) {
            FullRenderContext full = (FullRenderContext)pContext;
            PoseStack pPoseStack = full.poseStack();
            Item pAnimatable = (Item)full.animatable();
            VertexConsumer pBuffer = full.optionalBuffer();
            boolean pIsReRender = full.isReRender();
            float pPartialTick = full.partialTick();
            if (!pIsReRender) {
                AnimationState<Item> animationState = new AnimationState<Item>(pAnimatable, 0.0f, 0.0f, pPartialTick, false);
                long instanceId = this.getInstanceId(pContext);
                BlueModel<Item> currentModel = this.getBlueModel();
                animationState.setData(DataTickets.TICK, ((BlueAnimatable)pAnimatable).getTick(this.getCurrentItemStack()));
                animationState.setData(DataTickets.ITEM_RENDER_PERSPECTIVE, this.renderPerspective);
                animationState.setData(DataTickets.ITEMSTACK, this.currentItemStack);
                ((BlueAnimatable)pAnimatable).getAnimatableInstanceCache().getManagerForId(instanceId).setData(DataTickets.ITEM_RENDER_PERSPECTIVE, this.getRenderPerspective());
                currentModel.addAdditionalStateData(pAnimatable, instanceId, (x$0, x$1) -> animationState.setData(x$0, x$1));
                currentModel.handleAnimations(pAnimatable, instanceId, animationState, pPartialTick);
            }
            this.modelRenderTranslations = new Matrix4f((Matrix4fc)pPoseStack.last().pose());
            if (pBuffer != null) {
                BlueRenderer.super.actuallyRender(full);
            }
        } else if (pContext instanceof BaseRenderContext) {
            BaseRenderContext base = (BaseRenderContext)pContext;
            this.handleBaseActuallyRenderContext(base, this);
        }
    }

    @Override
    public void doPostRenderCleanup(@NotNull IRenderContext<T> pContext) {
        this.animatable = null;
        this.currentItemStack = null;
        this.renderPerspective = null;
    }

    @Override
    public void renderRecursively(@NotNull BoneCache pBone, @NotNull FullRenderContext<T> pContext) {
        if (pBone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)pContext.poseStack().last().pose());
            pBone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.modelRenderTranslations));
            pBone.setLocalSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRenderTranslations));
        }
        BlueRenderer.super.renderRecursively(pBone, pContext);
    }

    public void setupLightingForGuiRender() {
        if (this.useEntityGuiLighting) {
            Lighting.setupForEntityInInventory();
        } else {
            Lighting.setupForFlatItems();
        }
    }

    @Override
    public void updateAnimatedTextureFrame(@NotNull IRenderContext<T> pContext) {
        AnimatableTexture.setAndUpdate(this.getTextureLocation((Item)pContext.animatable()));
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireCompileItemRenderLayers(this);
    }

    @Override
    public boolean firePreRenderEvent(@NotNull IRenderContext<T> pContext) {
        return BlueLibConstants.PlatformHelper.EVENT_PROXY.fireItemPreRender(this, pContext);
    }

    @Override
    public void firePostRenderEvent(@NotNull IRenderContext<T> pContext) {
        BlueLibConstants.PlatformHelper.EVENT_PROXY.fireItemPostRender(this, pContext);
    }
}

