/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.markdown;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.config.MarkdownConfig;
import software.bluelib.internal.BlueTranslation;
import software.bluelib.markdown.syntax.Bold;
import software.bluelib.markdown.syntax.Color;
import software.bluelib.markdown.syntax.CopyToClipboard;
import software.bluelib.markdown.syntax.Hyperlink;
import software.bluelib.markdown.syntax.Italic;
import software.bluelib.markdown.syntax.Spoiler;
import software.bluelib.markdown.syntax.Strikethrough;
import software.bluelib.markdown.syntax.Underline;

public class MarkdownParser {
    @NotNull
    public static MutableComponent parseMarkdown(@NotNull Component pMessage) {
        if (!MarkdownConfig.isMarkdownEnabled) {
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.log("markdown.disabled"));
            return pMessage.copy();
        }
        String text = pMessage.getString();
        MutableComponent formattedMessage = Component.literal((String)text);
        formattedMessage = new Bold().apply(formattedMessage);
        formattedMessage = new Italic().apply(formattedMessage);
        formattedMessage = new Underline().apply(formattedMessage);
        formattedMessage = new Strikethrough().apply(formattedMessage);
        formattedMessage = new Spoiler().apply(formattedMessage);
        formattedMessage = new Hyperlink().apply(formattedMessage);
        formattedMessage = new Color().apply(formattedMessage);
        formattedMessage = new CopyToClipboard().apply(formattedMessage, text);
        BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.log("markdown.message"));
        return formattedMessage;
    }
}

