/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.markdown.syntax;

import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.config.MarkdownConfig;
import software.bluelib.internal.BlueTranslation;
import software.bluelib.markdown.MarkdownFeature;

public class CopyToClipboard
extends MarkdownFeature {
    @NotNull
    public MutableComponent apply(@NotNull MutableComponent pMessage, @NotNull String pTextToCopy) {
        if (!MarkdownConfig.isCopyToClipboardEnabled) {
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.log("markdown.copyToClipboard.disabled"));
            return pMessage;
        }
        MutableComponent result = Component.empty();
        for (Component sibling : pMessage.getSiblings()) {
            if (sibling instanceof MutableComponent) {
                MutableComponent mutableSibling = (MutableComponent)sibling;
                if (mutableSibling.getStyle().getClickEvent() == null) {
                    mutableSibling.setStyle(mutableSibling.getStyle().withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, pTextToCopy)));
                }
                result.append((Component)mutableSibling);
                continue;
            }
            result.append(sibling);
        }
        return result;
    }

    @Override
    @NotNull
    protected Boolean isFeatureEnabled() {
        return MarkdownConfig.isCopyToClipboardEnabled;
    }

    @Override
    @NotNull
    protected String getFeatureName() {
        return "CopyToClipboard";
    }
}

