/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.mixin.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import software.bluelib.BlueLibConstants;
import software.bluelib.BuildDetails;
import software.bluelib.client.gui.version.VersionWarningScreen;

@Mixin(value={Minecraft.class})
public final class VersionWarningMixin {
    @Unique
    @NotNull
    private static final Set<String> blueLib$dontShowAgain = new HashSet<String>();
    @Unique
    @NotNull
    private static final String FILE_NAME = "versionWarning.txt";
    @Unique
    private static boolean blueLib$loaded = false;

    @Unique
    private static void blueLib$loadDontShowAgain() {
        if (blueLib$loaded) {
            return;
        }
        blueLib$loaded = true;
        Path file = Path.of(FILE_NAME, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(file);){
                String line;
                while ((line = reader.readLine()) != null) {
                    blueLib$dontShowAgain.add(line.trim());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Unique
    private static void blueLib$saveDontShowAgain() {
        Path file = Path.of(FILE_NAME, new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            for (String key : blueLib$dontShowAgain) {
                writer.write(key);
                writer.newLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Inject(method={"addInitialScreens"}, at={@At(value="TAIL")})
    public void cobblemon$addSnapshotWarningScreen(@NotNull List<Function<Runnable, Screen>> pOutput, @NotNull CallbackInfo pCi) {
        VersionWarningMixin.blueLib$loadDontShowAgain();
        ServiceLoader<BuildDetails> loader = BlueLibConstants.loadAll(BuildDetails.class);
        for (BuildDetails details : loader) {
            String key = details.getModId() + ":" + details.getVersion();
            if (!details.displayWarning() || blueLib$dontShowAgain.contains(key)) continue;
            pOutput.add(runnable -> new VersionWarningScreen(details.getModId(), details.getVersion(), (ack, dontShow) -> {
                if (ack == VersionWarningScreen.Acknowledgement.NO) {
                    Minecraft.getInstance().close();
                }
                if (dontShow) {
                    blueLib$dontShowAgain.add(key);
                    VersionWarningMixin.blueLib$saveDontShowAgain();
                }
                runnable.run();
            }));
        }
    }
}

