/*
 * Decompiled with CFR 0.152.
 */
package me.nobaboy.nobaaddons.commands.adapters;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.celestialfault.commander.ArgumentHandler;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import kotlin.reflect.KParameter;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import org.jetbrains.annotations.NotNull;

public class FuzzyEnumHandler<T extends Enum<T>>
implements ArgumentHandler<T, FabricClientCommandSource> {
    private final T[] entries;
    private final Class<T> clazz;

    public FuzzyEnumHandler(@NotNull T[] entries) {
        this.entries = entries;
        this.clazz = ((Enum)Arrays.stream(entries).findFirst().orElseThrow()).getDeclaringClass();
    }

    public FuzzyEnumHandler(@NotNull Class<T> clazz) {
        this((Enum[])clazz.getEnumConstants());
    }

    @NotNull
    public ArgumentType<T> argument(@NotNull KParameter kParameter) {
        return new FuzzyEnumArgumentType(this.entries);
    }

    public T parse(@NotNull CommandContext<FabricClientCommandSource> context, @NotNull String name) {
        return (T)((Enum)context.getArgument(name, this.clazz));
    }

    public static class FuzzyEnumArgumentType<T extends Enum<T>>
    implements ArgumentType<T> {
        private final T[] entries;
        private static final DynamicCommandExceptionType INVALID_ENUM_EXCEPTION = new DynamicCommandExceptionType(value -> class_2561.method_54159((String)"argument.enum.invalid", (Object[])new Object[]{value}));

        public FuzzyEnumArgumentType(@NotNull T[] entries) {
            this.entries = (Enum[])Objects.requireNonNull(entries);
        }

        public T parse(StringReader stringReader) throws CommandSyntaxException {
            String string = stringReader.readUnquotedString().toLowerCase(Locale.ROOT);
            Object match = null;
            for (T entry : this.entries) {
                String name = ((class_3542)entry).method_15434().toLowerCase(Locale.ROOT);
                if (!name.startsWith(string)) continue;
                if (match != null) {
                    match = null;
                    break;
                }
                match = entry;
            }
            if (match == null) {
                throw INVALID_ENUM_EXCEPTION.create((Object)string);
            }
            return match;
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return class_2172.method_9265(Arrays.stream(this.entries).map(rec$ -> ((class_3542)rec$).method_15434()).toList(), (SuggestionsBuilder)builder);
        }
    }
}

