/*
 * Decompiled with CFR 0.152.
 */
package me.nobaboy.nobaaddons.commands.debug;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.celestialfault.commander.ArgumentHandler;
import dev.celestialfault.commander.Commander;
import dev.celestialfault.commander.annotations.Command;
import dev.celestialfault.commander.annotations.Group;
import dev.celestialfault.commander.annotations.RootCommand;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KParameter;
import kotlin.reflect.full.KClassifiers;
import kotlin.time.Duration;
import kotlin.time.Instant;
import me.nobaboy.nobaaddons.api.DebugAPI;
import me.nobaboy.nobaaddons.commands.debug.DebugCommands;
import me.nobaboy.nobaaddons.commands.impl.CommandUtils;
import me.nobaboy.nobaaddons.core.IEnchantment;
import me.nobaboy.nobaaddons.utils.TimeUtils;
import me.nobaboy.nobaaddons.utils.items.ItemUtils;
import me.nobaboy.nobaaddons.utils.items.SkyBlockItemData;
import me.nobaboy.nobaaddons.utils.mc.CodecUtils;
import me.nobaboy.nobaaddons.utils.mc.MCUtils;
import me.nobaboy.nobaaddons.utils.mc.text.BuilderKt;
import me.nobaboy.nobaaddons.utils.mc.text.StyleKt;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1132;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2203;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_8824;
import net.minecraft.class_9279;
import net.minecraft.class_9288;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Group(name="item", aliases={})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\t\u001a\u00020\b2\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\r\u001a\u00020\b2\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ-\u0010\u0011\u001a\u00020\b2\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0013\u001a\u00020\b2\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006H\u0007\u00a2\u0006\u0004\b\u0013\u0010\nJ!\u0010\u0014\u001a\u00020\b2\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006H\u0007\u00a2\u0006\u0004\b\u0014\u0010\n\u00a8\u0006\u0015"}, d2={"Lme/nobaboy/nobaaddons/commands/debug/ItemDebugCommands;", "", "<init>", "()V", "Lcom/mojang/brigadier/context/CommandContext;", "Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;", "Lme/nobaboy/nobaaddons/commands/impl/Context;", "ctx", "", "root", "(Lcom/mojang/brigadier/context/CommandContext;)V", "Lnet/minecraft/class_2203$class_2209;", "path", "nbt", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_2203$class_2209;)V", "", "line", "lore", "(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/Integer;)V", "fromClipboard", "containerFromClipboard", "nobaaddons"})
@SourceDebugExtension(value={"SMAP\nItemDebugCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemDebugCommands.kt\nme/nobaboy/nobaaddons/commands/debug/ItemDebugCommands\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 builder.kt\nme/nobaboy/nobaaddons/utils/mc/text/BuilderKt\n+ 5 CommandUtils.kt\nme/nobaboy/nobaaddons/commands/impl/CommandUtils\n+ 6 ArgumentHandler.kt\ndev/celestialfault/commander/ArgumentHandler$Companion\n+ 7 Commander.kt\ndev/celestialfault/commander/Commander\n*L\n1#1,174:1\n480#2:175\n426#2:176\n1252#3,4:177\n1869#3,2:182\n6#4:181\n6#4:184\n42#5:185\n43#5:192\n24#6,4:186\n59#7,2:190\n*S KotlinDebug\n*F\n+ 1 ItemDebugCommands.kt\nme/nobaboy/nobaaddons/commands/debug/ItemDebugCommands\n*L\n64#1:175\n64#1:176\n64#1:177,4\n103#1:182,2\n88#1:181\n112#1:184\n42#1:185\n42#1:192\n42#1:186,4\n42#1:190,2\n*E\n"})
public final class ItemDebugCommands {
    @NotNull
    public static final ItemDebugCommands INSTANCE;

    private ItemDebugCommands() {
    }

    /*
     * WARNING - void declaration
     */
    @RootCommand
    public final void root(@NotNull CommandContext<FabricClientCommandSource> ctx) {
        Map map;
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        class_746 class_7462 = MCUtils.INSTANCE.getPlayer();
        Intrinsics.checkNotNull((Object)class_7462);
        class_1799 item = class_7462.method_6047();
        Intrinsics.checkNotNull((Object)item);
        SkyBlockItemData itemData = ItemUtils.getAsSkyBlockItem(item);
        if (itemData == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)"You aren't holding a valid SkyBlock item"));
            return;
        }
        Pair[] pairArray = new Pair[16];
        pairArray[0] = TuplesKt.to((Object)"Item ID", (Object)itemData.getId());
        pairArray[1] = TuplesKt.to((Object)"UUID", (Object)itemData.getUuidAsString());
        Instant instant = itemData.getTimestamp();
        pairArray[2] = TuplesKt.to((Object)"Created", instant != null ? Duration.box-impl((long)TimeUtils.INSTANCE.elapsedSince-5sfh64U(instant)) : null);
        pairArray[3] = TuplesKt.to((Object)"Reforge", (Object)itemData.getReforge());
        pairArray[4] = TuplesKt.to((Object)"Rarity", (Object)itemData.getRarity());
        pairArray[5] = TuplesKt.to((Object)"Type", (Object)((Object)itemData.getType()));
        pairArray[6] = TuplesKt.to((Object)"Recombobulated", (Object)itemData.getRecombobulated());
        pairArray[7] = TuplesKt.to((Object)"Stars", (Object)itemData.getStars());
        Map<IEnchantment, Integer> map2 = itemData.getEnchantments();
        String string = "Enchants";
        int n = 8;
        Pair[] pairArray2 = pairArray;
        CommandContext<FabricClientCommandSource> commandContext = ctx;
        DebugCommands debugCommands = DebugCommands.INSTANCE;
        boolean $i$f$mapKeys = false;
        void var7_12 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string2 = ((IEnchantment)it.getKey()).getId();
            Map map3 = map;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(string2, entry);
        }
        map = destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)map);
        pairArray[9] = TuplesKt.to((Object)"Runes", itemData.getRunes());
        pairArray[10] = TuplesKt.to((Object)"Gemstones", itemData.getGemstones());
        pairArray[11] = TuplesKt.to((Object)"Power scroll", (Object)itemData.getPowerScroll());
        pairArray[12] = TuplesKt.to((Object)"Potion", (Object)itemData.getPotion());
        pairArray[13] = TuplesKt.to((Object)"Potion level", (Object)itemData.getPotionLevel());
        pairArray[14] = TuplesKt.to((Object)"Potion effects", itemData.getEffects());
        pairArray[15] = TuplesKt.to((Object)"Donated to Museum", (Object)itemData.getDonatedToMuseum());
        debugCommands.dumpInfo$nobaaddons(commandContext, pairArray);
    }

    /*
     * WARNING - void declaration
     */
    @Command(aliases={})
    public final void nbt(@NotNull CommandContext<FabricClientCommandSource> ctx, @Nullable class_2203.class_2209 path) {
        void $this$nbt_u24lambda_u241;
        class_5250 class_52502;
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        class_746 class_7462 = MCUtils.INSTANCE.getPlayer();
        Intrinsics.checkNotNull((Object)class_7462);
        class_1799 item = class_7462.method_6047();
        if (item.method_7960()) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)"You aren't holding an item"));
            return;
        }
        Object nbt2 = null;
        class_2487 class_24872 = ((class_9279)item.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        Intrinsics.checkNotNullExpressionValue((Object)class_24872, (String)"copyNbt(...)");
        nbt2 = class_24872;
        if (path != null) {
            List list = path.method_9366((class_2520)nbt2);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"get(...)");
            Object object = CollectionsKt.first((List)list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            nbt2 = object;
        }
        boolean $i$f$buildText = false;
        class_5250 class_52503 = class_52502 = class_2561.method_43473();
        FabricClientCommandSource fabricClientCommandSource = (FabricClientCommandSource)ctx.getSource();
        boolean bl = false;
        $this$nbt_u24lambda_u241.method_10852((class_2561)StyleKt.darkAqua(BuilderKt.toText("Item NBT: ")));
        $this$nbt_u24lambda_u241.method_10852(class_2512.method_32270((class_2520)((class_2520)nbt2)));
        class_5250 class_52504 = class_52502;
        Intrinsics.checkNotNullExpressionValue((Object)class_52504, (String)"apply(...)");
        fabricClientCommandSource.sendFeedback((class_2561)class_52504);
    }

    public static /* synthetic */ void nbt$default(ItemDebugCommands itemDebugCommands, CommandContext commandContext, class_2203.class_2209 class_22092, int n, Object object) {
        if ((n & 2) != 0) {
            class_22092 = null;
        }
        itemDebugCommands.nbt((CommandContext<FabricClientCommandSource>)commandContext, class_22092);
    }

    /*
     * WARNING - void declaration
     */
    @Command(aliases={})
    public final void lore(@NotNull CommandContext<FabricClientCommandSource> ctx, @Nullable Integer line) {
        void $this$lore_u24lambda_u244;
        class_5250 class_52502;
        class_2499 class_24992;
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        class_746 class_7462 = MCUtils.INSTANCE.getPlayer();
        Intrinsics.checkNotNull((Object)class_7462);
        class_1799 item = class_7462.method_6047();
        if (item.method_7960() || !item.method_57826(class_9334.field_49632)) {
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)class_2561.method_43470((String)"You aren't holding an item with lore"));
            return;
        }
        Object nbt2 = null;
        class_2499 $this$lore_u24lambda_u243 = class_24992 = new class_2499();
        boolean $i$a$-apply-ItemDebugCommands$lore$nbt$22 = false;
        List list = ((class_9290)item.method_58695(class_9334.field_49632, (Object)class_9290.field_49340)).comp_2400();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"lines(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_2561 it = (class_2561)element$iv;
            boolean bl = false;
            $this$lore_u24lambda_u243.add((Object)class_2519.method_23256((String)it.getString()));
        }
        nbt2 = class_24992;
        if (line != null) {
            class_2203.class_2209 path = class_2203.class_2209.method_58472((String)("[" + line + "]"));
            List list2 = path.method_9366((class_2520)nbt2);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"get(...)");
            Object object = CollectionsKt.first((List)list2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            nbt2 = object;
        }
        boolean $i$f$buildText = false;
        class_5250 $i$a$-apply-ItemDebugCommands$lore$nbt$22 = class_52502 = class_2561.method_43473();
        FabricClientCommandSource fabricClientCommandSource = (FabricClientCommandSource)ctx.getSource();
        boolean bl = false;
        $this$lore_u24lambda_u244.method_10852((class_2561)StyleKt.darkAqua(BuilderKt.toText("Item lore: ")));
        $this$lore_u24lambda_u244.method_10852(class_2512.method_32270((class_2520)((class_2520)nbt2)));
        class_5250 class_52503 = class_52502;
        Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"apply(...)");
        fabricClientCommandSource.sendFeedback((class_2561)class_52503);
    }

    public static /* synthetic */ void lore$default(ItemDebugCommands itemDebugCommands, CommandContext commandContext, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        itemDebugCommands.lore((CommandContext<FabricClientCommandSource>)commandContext, n);
    }

    @Command(aliases={})
    public final void fromClipboard(@NotNull CommandContext<FabricClientCommandSource> ctx) {
        class_1799 class_17992;
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        class_310 client = ((FabricClientCommandSource)ctx.getSource()).getClient();
        if (!client.method_1542()) {
            DebugAPI.INSTANCE.debugMessage((class_2561)StyleKt.red(BuilderKt.toText("This command can only be used in singleplayer")));
            return;
        }
        class_1132 class_11322 = client.method_1576();
        Intrinsics.checkNotNull((Object)class_11322);
        class_1132 integratedServer = class_11322;
        class_3222 class_32222 = integratedServer.method_3760().method_14602(((FabricClientCommandSource)ctx.getSource()).getPlayer().method_5667());
        Intrinsics.checkNotNull((Object)class_32222);
        class_3222 player = class_32222;
        String string = client.field_1774.method_1460();
        Intrinsics.checkNotNull((Object)string);
        String clipboard = string;
        try {
            JsonObject json = (JsonObject)new Gson().fromJson(clipboard, JsonObject.class);
            class_17992 = CodecUtils.INSTANCE.decodeFrom(CodecUtils.INSTANCE.getJSON(), ItemUtils.INSTANCE.getITEM_STACK_CODEC(), json);
        }
        catch (Exception ex) {
            DebugAPI.INSTANCE.debugMessage((class_2561)StyleKt.red(BuilderKt.toText("Couldn't decode clipboard contents; did you remember to copy the item you want to spawn?")));
            return;
        }
        class_1799 decoded = class_17992;
        class_5250 class_52502 = class_2561.method_43473().method_27693("Decoded ").method_10852(decoded.method_7964()).method_27693(" from clipboard");
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"append(...)");
        DebugAPI.INSTANCE.debugMessage((class_2561)class_52502);
        player.method_7270(decoded);
    }

    @Command(aliases={})
    public final void containerFromClipboard(@NotNull CommandContext<FabricClientCommandSource> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        class_310 client = ((FabricClientCommandSource)ctx.getSource()).getClient();
        if (!client.method_1542()) {
            DebugAPI.INSTANCE.debugMessage((class_2561)StyleKt.red(BuilderKt.toText("This command can only be used in singleplayer")));
            return;
        }
        class_1132 class_11322 = client.method_1576();
        Intrinsics.checkNotNull((Object)class_11322);
        class_1132 integratedServer = class_11322;
        class_3222 class_32222 = integratedServer.method_3760().method_14602(((FabricClientCommandSource)ctx.getSource()).getPlayer().method_5667());
        Intrinsics.checkNotNull((Object)class_32222);
        class_3222 player = class_32222;
        String string = client.field_1774.method_1460();
        Intrinsics.checkNotNull((Object)string);
        String clipboard = string;
        List slots = null;
        Ref.ObjectRef name = new Ref.ObjectRef();
        try {
            JsonObject json = (JsonObject)new Gson().fromJson(clipboard, JsonObject.class);
            slots = (List)CodecUtils.INSTANCE.decodeFrom(CodecUtils.INSTANCE.getJSON(), (Codec)ItemUtils.INSTANCE.getITEM_STACKS_CODEC(), json.get("slots").getAsJsonArray());
            DynamicOps<JsonElement> dynamicOps = CodecUtils.INSTANCE.getJSON();
            Codec codec = class_8824.field_46597;
            Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"CODEC");
            name.element = CodecUtils.INSTANCE.decodeFrom(dynamicOps, codec, json.get("name"));
        }
        catch (Exception ex) {
            DebugAPI.INSTANCE.debugMessage((class_2561)StyleKt.red(BuilderKt.toText("Couldn't decode clipboard contents; did you remember to copy the container you want to spawn?")));
            return;
        }
        List list = slots;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"slots");
            list = null;
        }
        CollectionsKt.chunked((Iterable)list, (int)27, arg_0 -> ItemDebugCommands.containerFromClipboard$lambda$5(name, player, arg_0));
        DebugAPI.INSTANCE.debugMessage("Decoded " + MathKt.roundToInt((double)Math.ceil((double)slots.size() / 27.0)) + " chest(s) worth of items");
    }

    private static final boolean containerFromClipboard$lambda$5(Ref.ObjectRef $name, class_3222 $player, List chunk) {
        class_2561 class_25612;
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        class_1799 chest = new class_1799((class_1935)class_1802.field_8106);
        chest.method_57379(class_9334.field_49622, (Object)class_9288.method_57493((List)chunk));
        if ($name.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
            class_25612 = null;
        } else {
            class_25612 = (class_2561)$name.element;
        }
        chest.method_57379(class_9334.field_49631, (Object)class_25612);
        return $player.method_7270(chest);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void handler$iv$iv;
        void this_$iv$iv;
        void $this$addHandler$iv;
        INSTANCE = new ItemDebugCommands();
        CommandUtils commandUtils = CommandUtils.INSTANCE;
        Commander<FabricClientCommandSource> commander = CommandUtils.INSTANCE.getCommander();
        class_2203 class_22032 = class_2203.method_9360();
        Intrinsics.checkNotNullExpressionValue((Object)class_22032, (String)"nbtPath(...)");
        ArgumentType type$iv = (ArgumentType)class_22032;
        boolean $i$f$addHandler = false;
        void var4_4 = $this$addHandler$iv;
        ArgumentHandler.Companion this_$iv$iv2 = ArgumentHandler.Companion;
        boolean $i$f$of = false;
        this_$iv$iv2 = (ArgumentHandler)new ArgumentHandler<class_2203.class_2209, FabricClientCommandSource>(type$iv){
            final /* synthetic */ ArgumentType $type;
            {
                this.$type = $type;
            }

            public ArgumentType<class_2203.class_2209> argument(KParameter parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                return this.$type;
            }

            public class_2203.class_2209 parse(CommandContext<FabricClientCommandSource> ctx, String name) {
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Object object = ctx.getArgument(name, class_2203.class_2209.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getArgument(...)");
                return object;
            }
        };
        boolean $i$f$addHandler2 = false;
        this_$iv$iv.getTypes().put(KClassifiers.getStarProjectedType((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(class_2203.class_2209.class))), handler$iv$iv);
    }
}

