/*
 * Decompiled with CFR 0.152.
 */
package me.nobaboy.nobaaddons.utils;

import java.text.NumberFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import me.nobaboy.nobaaddons.utils.NumberUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0004\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u0007\u001a\u00020\t*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0013\u0010\f\u001a\u00020\u000b*\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0004*\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0010\u001a\u00020\u0004*\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0011\u0010\u0013\u001a\u00020\u0012*\u00020\u000b\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0011\u0010\u0015\u001a\u00020\u0005*\u00020\u000b\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0005*\u00020\u000b\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0011\u0010\u0019\u001a\u00020\u0005*\u00020\u000b\u00a2\u0006\u0004\b\u0019\u0010\u0016J\u0011\u0010\u001b\u001a\u00020\u000b*\u00020\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0011\u0010\u001d\u001a\u00020\u000b*\u00020\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001cJ/\u0010!\u001a\u00020\u000b*\u00020\u00042\b\b\u0002\u0010\u001e\u001a\u00020\u00052\b\b\u0002\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010 \u001a\u00020\u0005\u00a2\u0006\u0004\b!\u0010\"J/\u0010!\u001a\u00020\u000b*\u00020\u00052\b\b\u0002\u0010\u001e\u001a\u00020\u00052\b\b\u0002\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010 \u001a\u00020\u0005\u00a2\u0006\u0004\b!\u0010#J\u0011\u0010$\u001a\u00020\u000b*\u00020\u001a\u00a2\u0006\u0004\b$\u0010\u001cR\u0015\u0010'\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0015\u0010)\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&\u00a8\u0006*"}, d2={"Lme/nobaboy/nobaaddons/utils/NumberUtils;", "", "<init>", "()V", "", "", "precision", "roundTo", "(DI)D", "", "(FI)F", "", "cleanTrailingZeros", "(D)Ljava/lang/String;", "parseDoubleOrNull", "(Ljava/lang/String;)Ljava/lang/Double;", "parseDouble", "(Ljava/lang/String;)D", "", "parseLong", "(Ljava/lang/String;)J", "parseInt", "(Ljava/lang/String;)I", "tryRomanToArabic", "(Ljava/lang/String;)Ljava/lang/Integer;", "romanToArabic", "", "addSeparators", "(Ljava/lang/Number;)Ljava/lang/String;", "toShortString", "thousandPrecision", "millionPrecision", "billionPrecision", "toAbbreviatedString", "(DIII)Ljava/lang/String;", "(IIII)Ljava/lang/String;", "ordinalSuffix", "getMillion", "(I)D", "million", "getBillion", "billion", "nobaaddons"})
@SourceDebugExtension(value={"SMAP\nNumberUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberUtils.kt\nme/nobaboy/nobaaddons/utils/NumberUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,120:1\n1#2:121\n1179#3,2:122\n*S KotlinDebug\n*F\n+ 1 NumberUtils.kt\nme/nobaboy/nobaaddons/utils/NumberUtils\n*L\n77#1:122,2\n*E\n"})
public final class NumberUtils {
    @NotNull
    public static final NumberUtils INSTANCE = new NumberUtils();

    private NumberUtils() {
    }

    public final double getMillion(int $this$million) {
        return (double)$this$million * 1000000.0;
    }

    public final double getBillion(int $this$billion) {
        return (double)$this$billion * 1.0E9;
    }

    public final double roundTo(double $this$roundTo, int precision) {
        double scale = Math.pow(10.0, precision);
        return (double)MathKt.roundToInt((double)($this$roundTo * scale)) / scale;
    }

    public final float roundTo(float $this$roundTo, int precision) {
        return (float)this.roundTo((double)$this$roundTo, precision);
    }

    private final String cleanTrailingZeros(double $this$cleanTrailingZeros) {
        CharSequence charSequence = String.valueOf($this$cleanTrailingZeros);
        Regex regex = NumberUtilsKt.access$getTRAILING_ZERO$p();
        String string = "";
        return regex.replace(charSequence, string);
    }

    @Nullable
    public final Double parseDoubleOrNull(@NotNull String $this$parseDoubleOrNull) {
        Double d;
        double d2;
        Intrinsics.checkNotNullParameter((Object)$this$parseDoubleOrNull, (String)"<this>");
        String string = $this$parseDoubleOrNull.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String text2 = StringsKt.replace$default((String)string, (String)",", (String)"", (boolean)false, (int)4, null);
        if (StringsKt.endsWith$default((String)text2, (String)"k", (boolean)false, (int)2, null)) {
            String string2 = text2.substring(0, text2.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            text2 = string2;
            d2 = 1000.0;
        } else if (StringsKt.endsWith$default((String)text2, (String)"m", (boolean)false, (int)2, null)) {
            String string3 = text2.substring(0, text2.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            text2 = string3;
            d2 = this.getMillion(1);
        } else if (StringsKt.endsWith$default((String)text2, (String)"b", (boolean)false, (int)2, null)) {
            String string4 = text2.substring(0, text2.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            text2 = string4;
            d2 = this.getBillion(1);
        } else {
            d2 = 1.0;
        }
        double multiplier = d2;
        Double d3 = StringsKt.toDoubleOrNull((String)text2);
        if (d3 != null) {
            double it = ((Number)d3).doubleValue();
            boolean bl = false;
            d = it * multiplier;
        } else {
            d = null;
        }
        return d;
    }

    public final double parseDouble(@NotNull String $this$parseDouble) {
        Intrinsics.checkNotNullParameter((Object)$this$parseDouble, (String)"<this>");
        Double d = this.parseDoubleOrNull($this$parseDouble);
        if (d == null) {
            throw new NumberFormatException("formatDouble failed for '" + $this$parseDouble + "'");
        }
        return d;
    }

    public final long parseLong(@NotNull String $this$parseLong) {
        Intrinsics.checkNotNullParameter((Object)$this$parseLong, (String)"<this>");
        Double d = this.parseDoubleOrNull($this$parseLong);
        if (d == null) {
            throw new NumberFormatException("formatLong failed for '" + $this$parseLong + "'");
        }
        return (long)d.doubleValue();
    }

    public final int parseInt(@NotNull String $this$parseInt) {
        Intrinsics.checkNotNullParameter((Object)$this$parseInt, (String)"<this>");
        Double d = this.parseDoubleOrNull($this$parseInt);
        if (d == null) {
            throw new NumberFormatException("formatInt failed for '" + $this$parseInt + "'");
        }
        return (int)d.doubleValue();
    }

    @Nullable
    public final Integer tryRomanToArabic(@NotNull String $this$tryRomanToArabic) {
        Intrinsics.checkNotNullParameter((Object)$this$tryRomanToArabic, (String)"<this>");
        Integer n = StringsKt.toIntOrNull((String)$this$tryRomanToArabic);
        if (n == null) {
            String $this$tryRomanToArabic_u24lambda_u241 = $this$tryRomanToArabic;
            boolean bl = false;
            n = NumberUtilsKt.access$getROMAN_NUMERALS_REGEX$p().matches((CharSequence)$this$tryRomanToArabic_u24lambda_u241) ? Integer.valueOf(INSTANCE.romanToArabic($this$tryRomanToArabic_u24lambda_u241)) : null;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final int romanToArabic(@NotNull String $this$romanToArabic) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$this$romanToArabic, (String)"<this>");
        int number = 0;
        int lastValue = 0;
        String string = $this$romanToArabic.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        CharSequence charSequence = ((Object)StringsKt.reversed((CharSequence)string)).toString();
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            Integer n = (Integer)NumberUtilsKt.access$getROMAN_NUMERAL_VALUES$p().get(Character.valueOf(c));
            int currentValue = n != null ? n : 0;
            number += currentValue < lastValue ? -currentValue : currentValue;
            lastValue = currentValue;
        }
        return number;
    }

    @NotNull
    public final String addSeparators(@NotNull Number $this$addSeparators) {
        Intrinsics.checkNotNullParameter((Object)$this$addSeparators, (String)"<this>");
        String string = NumberFormat.getNumberInstance().format($this$addSeparators);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public final String toShortString(@NotNull Number $this$toShortString) {
        Intrinsics.checkNotNullParameter((Object)$this$toShortString, (String)"<this>");
        String string = NumberFormat.getCompactNumberInstance().format($this$toShortString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public final String toAbbreviatedString(double $this$toAbbreviatedString, int thousandPrecision, int millionPrecision, int billionPrecision) {
        return $this$toAbbreviatedString >= 1.0E9 ? this.cleanTrailingZeros(this.roundTo($this$toAbbreviatedString / 1.0E9, billionPrecision)) + "b" : ($this$toAbbreviatedString >= 1000000.0 ? this.cleanTrailingZeros(this.roundTo($this$toAbbreviatedString / 1000000.0, millionPrecision)) + "m" : ($this$toAbbreviatedString >= 1000.0 ? this.cleanTrailingZeros(this.roundTo($this$toAbbreviatedString / 1000.0, thousandPrecision)) + "k" : this.cleanTrailingZeros($this$toAbbreviatedString)));
    }

    public static /* synthetic */ String toAbbreviatedString$default(NumberUtils numberUtils, double d, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = 1;
        }
        if ((n4 & 2) != 0) {
            n2 = 2;
        }
        if ((n4 & 4) != 0) {
            n3 = 1;
        }
        return numberUtils.toAbbreviatedString(d, n, n2, n3);
    }

    @NotNull
    public final String toAbbreviatedString(int $this$toAbbreviatedString, int thousandPrecision, int millionPrecision, int billionPrecision) {
        return this.toAbbreviatedString((double)$this$toAbbreviatedString, thousandPrecision, millionPrecision, billionPrecision);
    }

    public static /* synthetic */ String toAbbreviatedString$default(NumberUtils numberUtils, int n, int n2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n2 = 1;
        }
        if ((n5 & 2) != 0) {
            n3 = 2;
        }
        if ((n5 & 4) != 0) {
            n4 = 1;
        }
        return numberUtils.toAbbreviatedString(n, n2, n3, n4);
    }

    @NotNull
    public final String ordinalSuffix(@NotNull Number $this$ordinalSuffix) {
        Intrinsics.checkNotNullParameter((Object)$this$ordinalSuffix, (String)"<this>");
        long l = $this$ordinalSuffix.longValue();
        long l2 = l % (long)100;
        boolean bl = 11L <= l2 ? l2 < 14L : false;
        if (bl) {
            return "th";
        }
        l2 = l % (long)10;
        return l2 == 1L ? "st" : (l2 == 2L ? "nd" : (l2 == 3L ? "rd" : "th"));
    }
}

