#version 150

#moj_import <minecraft:globals.glsl>
#moj_import <nobaaddons:globals.glsl>

uniform sampler2D Sampler0;

in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

vec3 hsb2rgb(float h, float s, float b) {
	vec3 c = vec3(0.0, 4.0, 2.0);
	vec3 p = h * 6.0 + c;

	vec3 rgb = clamp(abs(mod(p, 6.0) - 3.0) - 1.0, 0.0, 1.0);
	rgb = smoothstep(0.0, 1.0, rgb);

	return b * mix(vec3(1.0), rgb, s);
}

void main() {
	vec4 color = texture(Sampler0, texCoord0);
	if(color.a < 0.01) discard;

	float direction = gl_FragCoord.x - gl_FragCoord.y;
	float offset = (NobaClientTime * 24000) * (6.0 / 360.0);
	float size = 30.0 * (ScreenSize.x / 100.0);

	float hue = fract(direction / size - offset);
	vec3 rgb = hsb2rgb(hue, 0.75, max(color.r, max(color.g, color.b)));

	fragColor = vec4(rgb, 1.0) * vertexColor;
}