/*
 * Decompiled with CFR 0.152.
 */
package me.nobaboy.nobaaddons.utils.math;

import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u0000 &2\u00020\u0001:\u0001&B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0007H\u0086\u0002\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0003H\u0086\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0010J\u0018\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0018\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0018\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0018H\u0086\u0002\u00a2\u0006\u0004\b\u0017\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0011\u0010#\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010%\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"\u00a8\u0006'"}, d2={"Lme/nobaboy/nobaaddons/utils/math/Matrix;", "", "", "", "data", "<init>", "([[D)V", "", "row", "get", "(I)[D", "value", "", "set", "(I[D)V", "copy", "()Lme/nobaboy/nobaaddons/utils/math/Matrix;", "transpose", "inverse", "other", "plus", "(Lme/nobaboy/nobaaddons/utils/math/Matrix;)Lme/nobaboy/nobaaddons/utils/math/Matrix;", "minus", "times", "", "scalar", "(D)Lme/nobaboy/nobaaddons/utils/math/Matrix;", "", "toString", "()Ljava/lang/String;", "[[D", "getData", "()[[D", "getWidth", "()I", "width", "getHeight", "height", "Companion", "nobaaddons"})
@SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\nme/nobaboy/nobaaddons/utils/math/Matrix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1#2:111\n1999#3,14:112\n*S KotlinDebug\n*F\n+ 1 Matrix.kt\nme/nobaboy/nobaaddons/utils/math/Matrix\n*L\n32#1:112,14\n*E\n"})
public final class Matrix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final double[][] data;

    public Matrix(@NotNull double[][] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.data = data2;
    }

    @NotNull
    public final double[][] getData() {
        return this.data;
    }

    public final int getWidth() {
        return this.data[0].length;
    }

    public final int getHeight() {
        return ((Object[])this.data).length;
    }

    @NotNull
    public final double[] get(int row) {
        return this.data[row];
    }

    public final void set(int row, @NotNull double[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.data[row] = value;
    }

    @NotNull
    public final Matrix copy() {
        int n = 0;
        int n2 = this.getHeight();
        double[][] dArrayArray = new double[n2][];
        while (n < n2) {
            int n3 = n++;
            double[] dArray = this.data[n3];
            Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(dArray, dArray.length), (String)"copyOf(...)");
        }
        double[][] dArrayArray2 = dArrayArray;
        return new Matrix(dArrayArray2);
    }

    @NotNull
    public final Matrix transpose() {
        int n = this.getWidth();
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int n3 = 0;
            int n4 = this.getHeight();
            double[] dArray = new double[n4];
            int n5 = n2;
            double[][] dArrayArray2 = dArrayArray;
            while (n3 < n4) {
                int n6 = n3++;
                dArray[n6] = this.data[n6][n2];
            }
            dArrayArray2[n5] = dArray;
        }
        double[][] dArrayArray3 = dArrayArray;
        return new Matrix(dArrayArray3);
    }

    @NotNull
    public final Matrix inverse() {
        if (!(this.getHeight() == this.getWidth())) {
            boolean $i$a$-require-Matrix$inverse$32 = false;
            String $i$a$-require-Matrix$inverse$32 = "Only square matrices are invertible";
            throw new IllegalArgumentException($i$a$-require-Matrix$inverse$32.toString());
        }
        double[][] a = this.copy().data;
        double[][] b = Matrix.Companion.identity((int)this.getWidth()).data;
        int n = this.getWidth();
        for (int column = 0; column < n; ++column) {
            Object maxElem$iv;
            Object v0;
            Iterable $this$maxByOrNull$iv = (Iterable)RangesKt.until((int)column, (int)this.getHeight());
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    int it = ((Number)maxElem$iv).intValue();
                    boolean bl = false;
                    double maxValue$iv = Math.abs(a[it][column]);
                    do {
                        Object e$iv = iterator$iv.next();
                        int it2 = ((Number)e$iv).intValue();
                        $i$a$-maxByOrNull-Matrix$inverse$maxRow$1 = false;
                        double v$iv = Math.abs(a[it2][column]);
                        if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Integer n2 = v0;
            if (n2 == null) {
                throw new IllegalStateException("Matrix is singular and cannot be inverted".toString());
            }
            int maxRow = n2;
            if (!(!(a[maxRow][column] == 0.0))) {
                boolean bl = false;
                String string = "Matrix is singular and cannot be inverted";
                throw new IllegalArgumentException(string.toString());
            }
            if (maxRow != column) {
                Matrix.Companion.swapRows(a, column, maxRow);
                Matrix.Companion.swapRows(b, column, maxRow);
            }
            double pivot = a[column][column];
            int i = column;
            int n3 = this.getWidth();
            while (i < n3) {
                maxElem$iv = a[column];
                int n4 = i++;
                maxElem$iv[n4] = maxElem$iv[n4] / pivot;
            }
            i = 0;
            n3 = this.getWidth();
            while (i < n3) {
                maxElem$iv = b[column];
                int n5 = i++;
                maxElem$iv[n5] = maxElem$iv[n5] / pivot;
            }
            n3 = this.getHeight();
            for (int row = 0; row < n3; ++row) {
                int n6;
                int i2;
                if (row == column) continue;
                double factor = a[row][column];
                int n7 = this.getWidth();
                for (i2 = column; i2 < n7; ++i2) {
                    double[] dArray = a[row];
                    n6 = i2;
                    dArray[n6] = dArray[n6] - factor * a[column][i2];
                }
                n7 = this.getWidth();
                for (i2 = 0; i2 < n7; ++i2) {
                    double[] dArray = b[row];
                    n6 = i2;
                    dArray[n6] = dArray[n6] - factor * b[column][i2];
                }
            }
        }
        return new Matrix(b);
    }

    @NotNull
    public final Matrix plus(@NotNull Matrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.getWidth() == other.getWidth() && this.getHeight() == other.getHeight())) {
            boolean bl = false;
            String string = "Matrix dimensions must match for addition";
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.getHeight();
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int n3 = 0;
            int n4 = this.getWidth();
            double[] dArray = new double[n4];
            int n5 = n2;
            double[][] dArrayArray2 = dArrayArray;
            while (n3 < n4) {
                int n6 = n3++;
                dArray[n6] = this.data[n2][n6] + other.get(n2)[n6];
            }
            dArrayArray2[n5] = dArray;
        }
        double[][] dArrayArray3 = dArrayArray;
        return new Matrix(dArrayArray3);
    }

    @NotNull
    public final Matrix minus(@NotNull Matrix other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.getWidth() == other.getWidth() && this.getHeight() == other.getHeight())) {
            boolean bl = false;
            String string = "Matrix dimensions must match for subtraction";
            throw new IllegalArgumentException(string.toString());
        }
        int n = this.getHeight();
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int n3 = 0;
            int n4 = this.getWidth();
            double[] dArray = new double[n4];
            int n5 = n2;
            double[][] dArrayArray2 = dArrayArray;
            while (n3 < n4) {
                int n6 = n3++;
                dArray[n6] = this.data[n2][n6] - other.get(n2)[n6];
            }
            dArrayArray2[n5] = dArray;
        }
        double[][] dArrayArray3 = dArrayArray;
        return new Matrix(dArrayArray3);
    }

    @NotNull
    public final Matrix times(@NotNull Matrix other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(this.getWidth() == other.getHeight())) {
            boolean $i$a$-require-Matrix$times$22 = false;
            String $i$a$-require-Matrix$times$22 = "Inner matrix dimensions must match for multiplication";
            throw new IllegalArgumentException($i$a$-require-Matrix$times$22.toString());
        }
        int $i$a$-require-Matrix$times$22 = 0;
        int n2 = this.getHeight();
        double[][] dArrayArray = new double[n2][];
        while ($i$a$-require-Matrix$times$22 < n2) {
            n = $i$a$-require-Matrix$times$22++;
            dArrayArray[n] = new double[other.getWidth()];
        }
        double[][] result = dArrayArray;
        n2 = this.getHeight();
        for (int row = 0; row < n2; ++row) {
            n = other.getWidth();
            for (int column = 0; column < n; ++column) {
                double sum = 0.0;
                int n3 = this.getWidth();
                for (int i = 0; i < n3; ++i) {
                    sum += this.get(row)[i] * other.get(i)[column];
                }
                result[row][column] = sum;
            }
        }
        return new Matrix(result);
    }

    @NotNull
    public final Matrix times(double scalar) {
        int n = this.getHeight();
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int n3 = 0;
            int n4 = this.getWidth();
            double[] dArray = new double[n4];
            int n5 = n2;
            double[][] dArrayArray2 = dArrayArray;
            while (n3 < n4) {
                int n6 = n3++;
                dArray[n6] = this.data[n2][n6] * scalar;
            }
            dArrayArray2[n5] = dArray;
        }
        double[][] dArrayArray3 = dArrayArray;
        return new Matrix(dArrayArray3);
    }

    @NotNull
    public String toString() {
        return ArraysKt.joinToString$default((Object[])((Object[])this.data), (CharSequence)"\n", null, null, (int)0, null, Matrix::toString$lambda$6, (int)30, null);
    }

    private static final CharSequence toString$lambda$6(double[] row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        return ArraysKt.joinToString$default((double[])row, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u000e\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lme/nobaboy/nobaaddons/utils/math/Matrix$Companion;", "", "<init>", "()V", "", "size", "Lme/nobaboy/nobaaddons/utils/math/Matrix;", "identity", "(I)Lme/nobaboy/nobaaddons/utils/math/Matrix;", "", "", "i", "j", "", "swapRows", "([[DII)V", "nobaaddons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Matrix identity(int size) {
            double[][] dArrayArray = new double[size][];
            for (int i = 0; i < size; ++i) {
                int n = i;
                double[] dArray = new double[size];
                int n2 = n;
                double[][] dArrayArray2 = dArrayArray;
                for (int j = 0; j < size; ++j) {
                    int n3 = j;
                    dArray[n3] = n == n3 ? 1.0 : 0.0;
                }
                dArrayArray2[n2] = dArray;
            }
            double[][] dArrayArray3 = dArrayArray;
            return new Matrix(dArrayArray3);
        }

        private final void swapRows(double[][] $this$swapRows, int i, int j) {
            double[] temp = $this$swapRows[i];
            $this$swapRows[i] = $this$swapRows[j];
            $this$swapRows[j] = temp;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

