/*
 * Decompiled with CFR 0.152.
 */
package me.nobaboy.nobaaddons.utils.math;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.nobaboy.nobaaddons.utils.NobaVec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u00020\u0005*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\t\u001a\u00020\u0005*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000e\u0010\r\u00a8\u0006\u000f"}, d2={"Lme/nobaboy/nobaaddons/utils/math/PolynomialUtils;", "", "<init>", "()V", "", "", "t", "valueAt", "([DD)D", "derivativeValueAt", "Lme/nobaboy/nobaaddons/utils/NobaVec;", "derivative", "calculatePitchWeight", "(Lme/nobaboy/nobaaddons/utils/NobaVec;)D", "invertPitchMapping", "nobaaddons"})
@SourceDebugExtension(value={"SMAP\nPolynomialUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolynomialUtils.kt\nme/nobaboy/nobaaddons/utils/math/PolynomialUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1803#2,3:48\n1818#2,4:51\n*S KotlinDebug\n*F\n+ 1 PolynomialUtils.kt\nme/nobaboy/nobaaddons/utils/math/PolynomialUtils\n*L\n11#1:48,3\n16#1:51,4\n*E\n"})
public final class PolynomialUtils {
    @NotNull
    public static final PolynomialUtils INSTANCE = new PolynomialUtils();

    private PolynomialUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public final double valueAt(@NotNull double[] $this$valueAt, double t) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$valueAt, (String)"<this>");
        Iterable iterable = ArraysKt.reversed((double[])$this$valueAt);
        double initial$iv = 0.0;
        boolean $i$f$fold = false;
        double accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void coefficient;
            double d = ((Number)element$iv).doubleValue();
            double accumulator = accumulator$iv;
            boolean bl = false;
            accumulator$iv = accumulator * t + coefficient;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final double derivativeValueAt(@NotNull double[] $this$derivativeValueAt, double t) {
        void $this$foldIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)$this$derivativeValueAt, (String)"<this>");
        List reversed = ArraysKt.dropLast((double[])ArraysKt.reversedArray((double[])$this$derivativeValueAt), (int)1);
        Iterable iterable = reversed;
        double initial$iv = 0.0;
        boolean $i$f$foldIndexed = false;
        int index$iv = 0;
        double accumulator$iv = initial$iv;
        for (Object element$iv : $this$foldIndexed$iv) {
            void coefficient;
            void accumulator;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            double d = ((Number)element$iv).doubleValue();
            double d2 = accumulator$iv;
            int i = n;
            boolean bl = false;
            accumulator$iv = accumulator * t + coefficient * (double)(reversed.size() - i);
        }
        return accumulator$iv;
    }

    public final double calculatePitchWeight(@NotNull NobaVec derivative) {
        Intrinsics.checkNotNullParameter((Object)derivative, (String)"derivative");
        double adjustedPitch = this.invertPitchMapping(derivative);
        return Math.sqrt((double)24 * Math.sin(adjustedPitch - Math.PI) + (double)25);
    }

    public final double invertPitchMapping(@NotNull NobaVec derivative) {
        Intrinsics.checkNotNullParameter((Object)derivative, (String)"derivative");
        double xzMagnitude = Math.sqrt(derivative.x() * derivative.x() + derivative.z() * derivative.z());
        double targetPitch = -Math.atan2(derivative.y(), xzMagnitude);
        double lowerBound = 0.0;
        lowerBound = -1.5707963267948966;
        double upperBound = 0.0;
        upperBound = 1.5707963267948966;
        double midpoint = 0.0;
        int n = 100;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            midpoint = (lowerBound + upperBound) / (double)2;
            double testPitch = Math.atan2(Math.sin(midpoint) - 0.75, Math.cos(midpoint));
            if (testPitch < targetPitch) {
                lowerBound = midpoint;
                continue;
            }
            if (testPitch > targetPitch) {
                upperBound = midpoint;
                continue;
            }
            return midpoint;
        }
        return (lowerBound + upperBound) / (double)2;
    }
}

