/*
 * Decompiled with CFR 0.152.
 */
package me.nobaboy.nobaaddons.utils.collections;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010)\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0011\u0010\rJ\u0017\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0012\u0010\rJ\u001d\u0010\u0015\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u001d\u0010\u0018\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0096\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0016R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010 R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010&\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006'"}, d2={"Lme/nobaboy/nobaaddons/utils/collections/EvictingList;", "", "T", "", "", "maxSize", "<init>", "(I)V", "", "isEmpty", "()Z", "element", "contains", "(Ljava/lang/Object;)Z", "firstOrNull", "()Ljava/lang/Object;", "lastOrNull", "add", "remove", "", "elements", "addAll", "(Ljava/util/Collection;)Z", "removeAll", "retainAll", "", "clear", "()V", "", "iterator", "()Ljava/util/Iterator;", "containsAll", "I", "Lkotlin/collections/ArrayDeque;", "deque", "Lkotlin/collections/ArrayDeque;", "getSize", "()I", "size", "nobaaddons"})
@SourceDebugExtension(value={"SMAP\nEvictingList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvictingList.kt\nme/nobaboy/nobaaddons/utils/collections/EvictingList\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n1#2:55\n1869#3,2:56\n*S KotlinDebug\n*F\n+ 1 EvictingList.kt\nme/nobaboy/nobaaddons/utils/collections/EvictingList\n*L\n33#1:56,2\n*E\n"})
public final class EvictingList<T>
implements Collection<T>,
KMutableCollection {
    private final int maxSize;
    @NotNull
    private final ArrayDeque<T> deque;

    public EvictingList(int maxSize) {
        this.maxSize = maxSize;
        if (!(this.maxSize > 0)) {
            boolean bl = false;
            String string = "Provided value must be a positive non-zero integer";
            throw new IllegalArgumentException(string.toString());
        }
        this.deque = new ArrayDeque();
    }

    public int getSize() {
        return this.deque.size();
    }

    @Override
    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object element) {
        if (element == null) {
            return false;
        }
        return this.deque.contains(element);
    }

    @Nullable
    public final T firstOrNull() {
        return (T)this.deque.firstOrNull();
    }

    @Nullable
    public final T lastOrNull() {
        return (T)this.deque.lastOrNull();
    }

    @Override
    public boolean add(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        this.deque.addFirst(element);
        while (this.deque.size() > this.maxSize) {
            this.deque.removeLast();
        }
        return true;
    }

    @Override
    public boolean remove(@Nullable Object element) {
        if (element == null) {
            return false;
        }
        return this.deque.remove(element);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        if (elements.isEmpty()) {
            return false;
        }
        if (!(elements.size() < this.maxSize)) {
            boolean $i$a$-require-EvictingList$addAll$22 = false;
            String $i$a$-require-EvictingList$addAll$22 = "Provided collection is larger than this list has capacity for";
            throw new IllegalArgumentException($i$a$-require-EvictingList$addAll$22.toString());
        }
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object p0 = element$iv = iterator.next();
            boolean bl = false;
            this.add((T)p0);
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.deque.removeAll(elements);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.deque.retainAll(elements);
    }

    @Override
    public void clear() {
        this.deque.clear();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.deque.iterator();
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.deque.containsAll(elements);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }
}

