/*
 * Decompiled with CFR 0.152.
 */
package com.afox.elementaryequipment.ability.active;

import com.afox.elementaryequipment.utils.EffectsUtils;
import com.afox.elementaryequipment.utils.EntityUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5819;

public class FrozenSwordActiveAbility {
    private static final int RADIUS = 16;
    private static final float AMOUNT_DAMAGE = 4.0f;
    private static final int EFFECT_DURATION = 200;
    private static final float FREEZE_BLOCK_CHANCE = 0.2f;
    private static final float PLACE_SNOWY_CHANCE = 0.4f;

    public static void execute(class_1937 world, class_1657 player) {
        if (world.method_8608()) {
            return;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            List<class_1309> livingEntities = EntityUtils.getEntitiesInArea((class_1937)serverWorld, player.method_19538(), 16.0);
            List<class_1309> hostileEntities = EntityUtils.FilterEntity.getEntitiesInScopes(livingEntities, player);
            FrozenSwordActiveAbility.playSound(serverWorld, player);
            FrozenSwordActiveAbility.spawnParticles(serverWorld, player);
            FrozenSwordActiveAbility.freezeBlocks(serverWorld, player);
            hostileEntities.forEach(hostileEntity -> {
                FrozenSwordActiveAbility.applyEffectsToEntity(hostileEntity);
                hostileEntity.method_5643(serverWorld.method_48963().method_48836(), 4.0f);
            });
        }
    }

    private static void freezeBlocks(class_3218 serverWorld, class_1657 player) {
        class_5819 random = serverWorld.method_8409();
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                for (int z = -16; z <= 16; ++z) {
                    class_2338 abovePos;
                    class_2680 aboveState;
                    class_2338 blockPos = player.method_24515().method_10069(x, y, z);
                    class_2680 currentState = serverWorld.method_8320(blockPos);
                    if (random.method_43057() < 0.2f && currentState.method_26164(class_3481.field_25806) || serverWorld.method_22351(blockPos)) {
                        FrozenSwordActiveAbility.playSoundFreezeBlock(serverWorld, blockPos);
                        serverWorld.method_8501(blockPos, class_2246.field_10295.method_9564());
                    }
                    if (!(random.method_43057() < 0.4f) || !currentState.method_26234((class_1922)serverWorld, blockPos) || !(aboveState = serverWorld.method_8320(abovePos = blockPos.method_10084())).method_45474() || aboveState.method_26227().method_15771()) continue;
                    serverWorld.method_8501(abovePos, class_2246.field_10477.method_9564());
                }
            }
        }
    }

    private static void playSoundFreezeBlock(class_3218 serverWorld, class_2338 blockPos) {
        serverWorld.method_8396(null, blockPos, class_3417.field_15081, class_3419.field_15245, 0.3f, 1.0f);
    }

    private static void playSound(class_3218 serverWorld, class_1657 player) {
        serverWorld.method_8396(null, player.method_24515(), class_3417.field_15081, class_3419.field_15251, 1.0f, 0.5f);
    }

    private static void spawnParticles(class_3218 serverWorld, class_1657 player) {
        for (int i = 0; i < 100; ++i) {
            class_5819 random = serverWorld.method_8409();
            double x = player.method_23317() + (random.method_43058() - 0.5) * 10.0;
            double y = player.method_23318() + (random.method_43058() - 0.5) * 10.0;
            double z = player.method_23321() + (random.method_43058() - 0.5) * 10.0;
            serverWorld.method_14199((class_2394)class_2398.field_28013, x, y, z, 2, 0.0, 0.0, 0.0, 0.1);
        }
    }

    private static void applyEffectsToEntity(class_1309 livingEntity) {
        Map<class_1291, Integer> effects = Map.of(class_1294.field_5909, 100, class_1294.field_5911, 100, class_1294.field_5901, 100);
        EffectsUtils.applyEffectsToEntity(livingEntity, effects, 200);
    }
}

