/*
 * Decompiled with CFR 0.152.
 */
package com.afox.elementaryequipment.config;

import com.afox.elementaryequipment.ModElementaryEquipment;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("elementary-equipment.json");
    private static ConfigData config;
    private static final int MIN_COOLDOWN = 0;
    private static final int MAX_COOLDOWN = 1000;
    private static final float MIN_CHANCE = 0.1f;
    private static final float MAX_CHANCE = 1.0f;
    private static final int MIN_XP = 0;
    private static final int MAX_XP = 1000;
    private static final int MIN_DURABILITY = 0;
    private static final int MAX_DURABILITY = 1562;

    public static void loadConfig() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String content = Files.readString(CONFIG_PATH);
                config = (ConfigData)GSON.fromJson(content, ConfigData.class);
                ModConfig.validateAndCorrectConfig(config);
                ModConfig.saveConfig();
                ModElementaryEquipment.LOGGER.info("Config loaded successfully");
            } else {
                config = new ConfigData();
                ModConfig.saveConfig();
                ModElementaryEquipment.LOGGER.info("Created default config");
            }
        }
        catch (IOException error) {
            ModElementaryEquipment.LOGGER.error("Failed to load config", (Throwable)error);
            config = new ConfigData();
        }
    }

    public static void saveConfig() throws IOException {
        String json = GSON.toJson((Object)config);
        Path parentDir = CONFIG_PATH.getParent();
        if (parentDir != null) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
    }

    public static ConfigData getConfig() {
        return config;
    }

    private static void validateAndCorrectConfig(ConfigData config) {
        ModConfig.validateConfig(config.ancientSword);
        ModConfig.validateConfig(config.electricSword);
        ModConfig.validateConfig(config.fireSword);
        ModConfig.validateConfig(config.frozenSword);
        ModConfig.validateConfig(config.hurricaneSword);
        ModConfig.validateConfig(config.magicSword);
        ModConfig.validateConfig(config.mountainSword);
        ModConfig.validateConfig(config.seaSword);
    }

    private static void validateConfig(ConfigData.BaseSword sword) {
        sword.activeCooldown = Math.min(Math.max(sword.activeCooldown, 0), 1000);
        sword.passiveCooldown = Math.min(Math.max(sword.passiveCooldown, 0), 1000);
        sword.passiveChance = Math.min(Math.max(sword.passiveChance, 0.1f), 1.0f);
        sword.xpCost = Math.min(Math.max(sword.xpCost, 0), 1000);
        sword.durabilityCost = Math.min(Math.max(sword.durabilityCost, 0), 1562);
    }

    public static class ConfigData {
        public AncientSword ancientSword = new AncientSword();
        public ElectricSword electricSword = new ElectricSword();
        public FireSword fireSword = new FireSword();
        public FrozenSword frozenSword = new FrozenSword();
        public HurricaneSword hurricaneSword = new HurricaneSword();
        public MagicSword magicSword = new MagicSword();
        public MountainSword mountainSword = new MountainSword();
        public SeaSword seaSword = new SeaSword();
        public General general = new General();

        public static class AncientSword
        extends BaseSword {
            public AncientSword() {
                super(20, 40, 0.0f, 4, 1);
            }
        }

        public static class ElectricSword
        extends BaseSword {
            public ElectricSword() {
                super(90, 45, 0.2f, 22, 3);
            }
        }

        public static class FireSword
        extends BaseSword {
            public FireSword() {
                super(45, 30, 0.6f, 16, 2);
            }
        }

        public static class FrozenSword
        extends BaseSword {
            public FrozenSword() {
                super(45, 30, 0.3f, 16, 2);
            }
        }

        public static class HurricaneSword
        extends BaseSword {
            public HurricaneSword() {
                super(45, 10, 0.7f, 14, 1);
            }
        }

        public static class MagicSword
        extends BaseSword {
            public MagicSword() {
                super(120, 40, 0.0f, 14, 1);
            }
        }

        public static class MountainSword
        extends BaseSword {
            public MountainSword() {
                super(120, 40, 0.0f, 14, 1);
            }
        }

        public static class SeaSword
        extends BaseSword {
            public SeaSword() {
                super(35, 20, 0.0f, 5, 1);
            }
        }

        public static class General {
            private static final String README = "Select entities affected by ability: (all, players, animals, monsters)";
            public Set<String> entityScopes = Set.of("all");
        }

        public static class BaseSword {
            public int activeCooldown;
            public int passiveCooldown;
            public float passiveChance;
            public int xpCost;
            public int durabilityCost;

            public BaseSword(int activeCooldown, int passiveCooldown, float passiveChance, int xpCost, int durabilityCost) {
                this.activeCooldown = activeCooldown;
                this.passiveCooldown = passiveCooldown;
                this.passiveChance = passiveChance;
                this.xpCost = xpCost;
                this.durabilityCost = durabilityCost;
            }
        }
    }
}

