/*
 * Decompiled with CFR 0.152.
 */
package com.afox.elementaryequipment.utils;

import com.afox.elementaryequipment.config.ModConfig;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1429;
import net.minecraft.class_1569;
import net.minecraft.class_1657;

public class EffectsUtils {
    private static final Set<String> ENTITY_SCOPES = ModConfig.getConfig().general.entityScopes;

    public static void applyEffectsToEntity(class_1309 livingEntity, Map<class_1291, Integer> effects, int effectDuration) {
        effects.forEach((effect, amplifier) -> livingEntity.method_6092(new class_1293(effect, effectDuration, amplifier.intValue(), false, false)));
    }

    public static void applyEffectsToEntities(List<class_1309> livingEntities, Map<class_1291, Integer> effects, int effectDuration) {
        for (class_1309 livingEntity : livingEntities) {
            effects.forEach((effect, amplifier) -> livingEntity.method_6092(new class_1293(effect, effectDuration, amplifier.intValue(), false, false)));
        }
    }

    public static void applyEffectsInScopesToEntities(List<class_1309> livingEntities, Map<class_1291, Integer> badEffects, Map<class_1291, Integer> goodEffects, class_1657 player, int effectDuration) {
        List<class_1309> friendlyEntities;
        List<class_1309> hostileEntities;
        if (ENTITY_SCOPES.contains("all")) {
            hostileEntities = livingEntities.stream().filter(entity -> entity != player && (!(entity instanceof class_1321) || !((class_1321)entity).method_6181())).toList();
            friendlyEntities = livingEntities.stream().filter(entity -> entity == player || EffectsUtils.isTamedByPlayer(entity, player)).toList();
        } else {
            hostileEntities = livingEntities.stream().filter(entity -> {
                if (entity == player) {
                    return false;
                }
                for (String scope : ENTITY_SCOPES) {
                    if (!EffectsUtils.matchesScope(entity, scope)) continue;
                    return true;
                }
                return false;
            }).toList();
            friendlyEntities = livingEntities.stream().filter(entity -> !ENTITY_SCOPES.contains("players") && entity.method_31747() || entity == player || EffectsUtils.isTamedByPlayer(entity, player)).toList();
        }
        EffectsUtils.applyEffectsToEntities(hostileEntities, badEffects, effectDuration);
        EffectsUtils.applyEffectsToEntities(friendlyEntities, goodEffects, effectDuration);
    }

    private static boolean matchesScope(class_1309 entity, String scope) {
        return switch (scope) {
            case "players" -> entity instanceof class_1657;
            case "monsters" -> entity instanceof class_1569;
            case "animals" -> {
                if (!(!(entity instanceof class_1429) || entity instanceof class_1321 && ((class_1321)entity).method_6181())) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean isTamedByPlayer(class_1309 entity, class_1657 player) {
        if (entity instanceof class_1321) {
            class_1321 tameable = (class_1321)entity;
            return tameable.method_6181() && tameable.method_35057() == player;
        }
        return false;
    }
}

