/*
 * Decompiled with CFR 0.152.
 */
package com.afox.elementaryequipment.ability.active;

import com.afox.elementaryequipment.utils.EffectsUtils;
import com.afox.elementaryequipment.utils.EntityUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1669;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class AncientSwordActiveAbility {
    private static final int CIRCLE_RADIUS = 24;
    private static final int EFFECT_DURATION = 300;
    private static final float GRASS_SPAWN_CHANCE = 0.5f;
    private static final float TALL_GRASS_RATIO = 0.3f;
    private static final int VERTICAL_RANGE = 3;
    private static final int PARTICLE_COUNT = 60;

    public static void execute(class_1937 world, class_1657 player) {
        if (world.method_8608()) {
            return;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_2338 blockPos = player.method_24515();
            class_5819 random = serverWorld.method_8409();
            List<class_1309> livingEntities = EntityUtils.getEntitiesInArea((class_1937)serverWorld, player.method_19538(), 24.0);
            AncientSwordActiveAbility.playSound(serverWorld, player);
            AncientSwordActiveAbility.applyEffectsToEntities(livingEntities, player);
            AncientSwordActiveAbility.spawnParticles(serverWorld, blockPos, random);
            AncientSwordActiveAbility.spawnGrassInCircle(serverWorld, blockPos, random);
            AncientSwordActiveAbility.spawnEvokerFangs(livingEntities, serverWorld, player);
        }
    }

    private static void spawnGrassInCircle(class_3218 serverWorld, class_2338 center, class_5819 random) {
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (int x = -24; x <= 24; ++x) {
            for (int z = -24; z <= 24; ++z) {
                for (int yOffset = -3; yOffset <= 3; ++yOffset) {
                    mutablePos.method_10103(center.method_10263() + x, center.method_10264() + yOffset, center.method_10260() + z);
                    class_1923 chunkPos = new class_1923((class_2338)mutablePos);
                    if (!serverWorld.method_8393(chunkPos.field_9181, chunkPos.field_9180) || !(random.method_43057() <= 0.5f) || !serverWorld.method_8320(mutablePos.method_10074()).method_27852(class_2246.field_10219) || !serverWorld.method_8320((class_2338)mutablePos).method_26215()) continue;
                    if (random.method_43057() <= 0.3f) {
                        AncientSwordActiveAbility.placeTallGrass(serverWorld, (class_2338)mutablePos);
                        continue;
                    }
                    serverWorld.method_8501((class_2338)mutablePos, class_2246.field_10479.method_9564());
                }
            }
        }
    }

    private static void placeTallGrass(class_3218 serverWorld, class_2338 pos) {
        if (serverWorld.method_8320(pos.method_10084()).method_26215()) {
            class_2680 lowerState = (class_2680)class_2246.field_10214.method_9564().method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12607);
            class_2680 upperState = (class_2680)class_2246.field_10214.method_9564().method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12609);
            serverWorld.method_8501(pos, lowerState);
            serverWorld.method_8501(pos.method_10084(), upperState);
        }
    }

    private static void spawnEvokerFangs(List<class_1309> livingEntities, class_3218 serverWorld, class_1657 player) {
        EntityUtils.FilterEntity.getEntitiesInScopes(livingEntities, player).forEach(target -> {
            class_1669 evokerFangs = new class_1669(class_1299.field_6060, (class_1937)serverWorld);
            evokerFangs.method_5814(target.method_23317(), target.method_23318(), target.method_23321());
            evokerFangs.method_7473((class_1309)player);
            serverWorld.method_8649((class_1297)evokerFangs);
        });
    }

    private static void playSound(class_3218 serverWorld, class_1657 player) {
        for (int i = 0; i < 5; ++i) {
            serverWorld.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14653, class_3419.field_15245, 0.8f, 0.9f + serverWorld.method_8409().method_43057() * 0.2f);
        }
    }

    private static void spawnParticles(class_3218 serverWorld, class_2338 blockPos, class_5819 random) {
        for (int i = 0; i < 60; ++i) {
            double x = (double)blockPos.method_10263() + (random.method_43058() - 0.5) * 24.0 * 2.0;
            double z = (double)blockPos.method_10260() + (random.method_43058() - 0.5) * 24.0 * 2.0;
            double y = (double)blockPos.method_10264() + random.method_43058();
            serverWorld.method_14199((class_2394)class_2398.field_11211, x, y, z, 5, 0.0, 0.1, 0.0, 0.1);
        }
    }

    private static void applyEffectsToEntities(List<class_1309> livingEntities, class_1657 player) {
        Map<class_1291, Integer> hostileEffects = Map.of(class_1294.field_5909, 3, class_1294.field_5899, 1);
        Map<class_1291, Integer> friendlyEffects = Map.of(class_1294.field_5924, 0, class_1294.field_5914, 2, class_1294.field_5913, 1, class_1294.field_5904, 1);
        EffectsUtils.applyEffectsInScopesToEntities(livingEntities, hostileEffects, friendlyEffects, player, 300);
    }
}

