/*
 * Decompiled with CFR 0.152.
 */
package com.afox.elementaryequipment.utils;

import com.afox.elementaryequipment.config.ModConfig;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1429;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;

public class EntityUtils {
    private static final Set<String> ENTITY_SCOPES = ModConfig.getConfig().general.entityScopes;

    public static List<class_1309> getEntitiesInArea(class_1937 world, class_243 center, double radius) {
        return world.method_8390(class_1309.class, EntityUtils.getBox(center, radius), entity -> entity.method_5805() && entity.method_5707(center) <= radius * radius);
    }

    private static boolean matchesScope(class_1309 entity, String scope) {
        return switch (scope) {
            case "players" -> entity instanceof class_1657;
            case "monsters" -> entity instanceof class_1569;
            case "animals" -> {
                if (!(!(entity instanceof class_1429) || entity instanceof class_1321 && ((class_1321)entity).method_6181())) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static class_238 getBox(class_243 vec3d, double radius) {
        return new class_238(vec3d.method_10216() - radius, vec3d.method_10214() - radius, vec3d.method_10215() - radius, vec3d.method_10216() + radius, vec3d.method_10214() + radius, vec3d.method_10215() + radius);
    }

    public static class FilterEntity {
        public static List<class_1309> getEntitiesInScopes(List<class_1309> livingEntities, class_1657 player) {
            if (ENTITY_SCOPES.contains("all")) {
                return livingEntities.stream().filter(entity -> {
                    class_1321 tameable;
                    return entity != player && (!(entity instanceof class_1321) || !(tameable = (class_1321)entity).method_6181());
                }).collect(Collectors.toList());
            }
            return livingEntities.stream().filter(entity -> {
                if (entity == player) {
                    return false;
                }
                for (String scope : ENTITY_SCOPES) {
                    if (!EntityUtils.matchesScope(entity, scope)) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        }
    }
}

