/*
 * Decompiled with CFR 0.152.
 */
package com.afox.elementaryequipment.ability.active;

import com.afox.elementaryequipment.events.DelayedTaskScheduler;
import com.afox.elementaryequipment.utils.EffectsUtils;
import com.afox.elementaryequipment.utils.EntityUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;

public class ElectricSwordActiveAbility {
    private static final Map<UUID, ActiveMobParticle> activeMobParticles = new HashMap<UUID, ActiveMobParticle>();
    private static final int RADIUS = 30;
    private static final int MOB_QUANTITY = 5;
    private static final int LIGHTNING_DAMAGE = 20;
    private static final int EFFECT_DURATION = 120;
    private static final int MIN_TICK_FOR_SOUNDS = 40;
    private static final int MAX_TICK_FOR_SOUNDS = 160;
    private static final int STEP_TICK_FOR_SOUNDS = 30;
    private static final int MAX_TICKS_BEFORE_ACTION = 40;
    private static int tickCounter = 0;

    public static void execute(class_1937 world, class_1657 player) {
        if (world.method_8608()) {
            return;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            ElectricSwordActiveAbility.spawnParticles(serverWorld, player);
            ElectricSwordActiveAbility.scheduleSounds(serverWorld, player);
            ElectricSwordActiveAbility.scheduleWeather(serverWorld);
            ElectricSwordActiveAbility.processMobs(serverWorld, player);
        }
    }

    private static void scheduleSounds(class_3218 serverWorld, class_1657 player) {
        for (int i = 40; i < 160; i += 30) {
            int randomNumber = 20 + serverWorld.field_9229.method_43048(6) * 16;
            DelayedTaskScheduler.schedule(100 + randomNumber, () -> ElectricSwordActiveAbility.playSound(serverWorld, player));
        }
    }

    private static void scheduleWeather(class_3218 serverWorld) {
        DelayedTaskScheduler.schedule(100, () -> serverWorld.method_27910(0, 400, true, true));
    }

    private static void processMobs(class_3218 serverWorld, class_1657 player) {
        List<class_1309> livingEntities = EntityUtils.getEntitiesInArea((class_1937)serverWorld, player.method_19538(), 30.0);
        EntityUtils.FilterEntity.getEntitiesInScopes(livingEntities, player).stream().filter(mobEntity -> ElectricSwordActiveAbility.canSpawnLightning((class_1937)serverWorld, mobEntity.method_24515())).limit(5L).forEach(livingEntity -> {
            activeMobParticles.put(livingEntity.method_5667(), new ActiveMobParticle((class_1297)livingEntity, serverWorld, 26));
            DelayedTaskScheduler.schedule(300, () -> {
                if (livingEntity.method_5805()) {
                    ElectricSwordActiveAbility.summonCustomLightningBolt(serverWorld, livingEntity);
                    ElectricSwordActiveAbility.applyEffectsToEntities(livingEntity);
                }
            });
        });
    }

    public static boolean canSpawnLightning(class_1937 world, class_2338 pos) {
        return world.method_8311(pos);
    }

    private static void summonCustomLightningBolt(class_3218 serverWorld, class_1309 livingEntity) {
        class_1538 lightning = new class_1538(class_1299.field_6112, (class_1937)serverWorld);
        lightning.method_33574(livingEntity.method_19538());
        lightning.method_29498(true);
        serverWorld.method_8649((class_1297)lightning);
        livingEntity.method_5643(serverWorld.method_48963().method_48809(), 20.0f);
        livingEntity.method_5639(100);
    }

    private static void playSound(class_3218 serverWorld, class_1657 player) {
        serverWorld.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14865, class_3419.field_15256, 0.3f + serverWorld.method_8409().method_43057() * 0.6f, 0.3f + serverWorld.method_8409().method_43057() * 0.8f);
    }

    private static void spawnParticles(class_3218 serverWorld, class_1657 player) {
        serverWorld.method_14199((class_2394)class_2398.field_11248, player.method_23317(), player.method_23318(), player.method_23321(), 20, 0.3, 0.3, 0.3, 0.1);
    }

    private static void applyEffectsToEntities(class_1309 livingEntity) {
        Map<class_6880<class_1291>, Integer> effects = Map.of(class_1294.field_5909, 5, class_1294.field_5911, 1);
        EffectsUtils.applyEffectsToEntity(livingEntity, effects, 120);
    }

    public static void tickAll() {
        if (++tickCounter < 40) {
            return;
        }
        tickCounter = 0;
        activeMobParticles.values().removeIf(circle -> !circle.tick());
    }

    private static class ActiveMobParticle {
        private final class_1297 entity;
        private final class_3218 serverWorld;
        private int remainingTicks;

        public ActiveMobParticle(class_1297 entity, class_3218 serverWorld, int duration) {
            this.entity = entity;
            this.serverWorld = serverWorld;
            this.remainingTicks = duration;
        }

        public boolean tick() {
            --this.remainingTicks;
            if (this.remainingTicks <= 0) {
                return false;
            }
            this.spawnMobParticles();
            return true;
        }

        private void spawnMobParticles() {
            for (int i = 0; i < 360; i += 40) {
                double radians = Math.toRadians(i);
                double offsetX = Math.cos(radians) * -1.0;
                double offsetZ = Math.sin(radians) * -1.0;
                this.serverWorld.method_14199((class_2394)class_2398.field_11248, this.entity.method_23317() + offsetX, this.entity.method_23318() + 1.0, this.entity.method_23321() + offsetZ, 3, 0.0, 0.0, 0.0, 0.1);
            }
        }
    }
}

