/*
 * Decompiled with CFR 0.152.
 */
package com.afox.elementaryequipment.ability.active;

import com.afox.elementaryequipment.utils.EffectsUtils;
import com.afox.elementaryequipment.utils.EntityUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;

public class MagicSwordActiveAbility {
    private static final Map<UUID, ActiveCircle> activeCircles = new HashMap<UUID, ActiveCircle>();
    private static final int CIRCLE_RADIUS = 16;
    private static final int EFFECT_DURATION = 100;
    private static final int CIRCLE_DURATION = 40;
    private static final int MAX_TICKS_BEFORE_ACTION = 60;
    private static int tickCounter = 0;

    public static void execute(class_1937 world, class_1657 player) {
        if (world.method_8608()) {
            return;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            MagicSwordActiveAbility.playSound(serverWorld, player);
            MagicSwordActiveAbility.spawnParticles(serverWorld, player);
            activeCircles.put(player.method_5667(), new ActiveCircle(player, player.method_19538(), serverWorld, 40));
        }
    }

    private static void playSound(class_3218 serverWorld, class_1657 player) {
        serverWorld.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_23118, class_3419.field_15256, 2.5f, 0.8f);
    }

    private static void spawnParticles(class_3218 serverWorld, class_1657 player) {
        serverWorld.method_14199((class_2394)class_2398.field_11249, player.method_23317(), player.method_23318() + (double)(player.method_17682() / 2.0f), player.method_23321(), 45, 0.8, 0.8, 0.8, 0.01);
    }

    public static void tickAll() {
        if (++tickCounter < 60) {
            return;
        }
        tickCounter = 0;
        activeCircles.values().removeIf(circle -> !circle.tick());
    }

    private static class ActiveCircle {
        private final class_1657 player;
        private final class_243 center;
        private final class_3218 serverWorld;
        private int remainingTicks;

        public ActiveCircle(class_1657 player, class_243 center, class_3218 serverWorld, int durationTicks) {
            this.player = player;
            this.center = center;
            this.serverWorld = serverWorld;
            this.remainingTicks = durationTicks;
        }

        public boolean tick() {
            --this.remainingTicks;
            if (this.remainingTicks <= 0) {
                return false;
            }
            this.spawnCircleParticles();
            this.applyEffectsToEntities(this.serverWorld, this.player);
            return true;
        }

        private void spawnCircleParticles() {
            double yPos = this.center.field_1351 + 0.3;
            for (int i = 0; i < 360; i += 3) {
                double rad = Math.toRadians(i);
                double x = this.center.field_1352 + 16.0 * Math.cos(rad);
                double z = this.center.field_1350 + 16.0 * Math.sin(rad);
                this.serverWorld.method_14199((class_2394)class_2398.field_11216, x, yPos, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            this.serverWorld.method_14199((class_2394)class_2398.field_22246, this.center.field_1352, this.center.field_1351 + 1.5, this.center.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }

        private void applyEffectsToEntities(class_3218 serverWorld, class_1657 player) {
            Map<class_6880<class_1291>, Integer> hostileEffects = Map.of(class_1294.field_5911, 0, class_1294.field_5909, 2);
            Map<class_6880<class_1291>, Integer> friendlyEffects = Map.of(class_1294.field_5924, 0, class_1294.field_5898, 0, class_1294.field_5904, 0);
            List<class_1309> livingEntities = EntityUtils.getEntitiesInArea((class_1937)serverWorld, this.center, 16.0);
            EffectsUtils.applyEffectsInScopesToEntities(livingEntities, hostileEffects, friendlyEffects, player, 100);
        }
    }
}

