/*
 * Decompiled with CFR 0.152.
 */
package com.afox.elementaryequipment.events;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;

public class DelayedTaskScheduler {
    private static final List<Task> tasks = new ArrayList<Task>();

    public static void schedule(int delayTicks, Runnable task) {
        tasks.add(new Task(delayTicks, task));
    }

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ArrayList<Task> completedTasks = new ArrayList<Task>();
            for (Task task : tasks) {
                --task.ticksRemaining;
                if (task.ticksRemaining > 0) continue;
                task.action.run();
                completedTasks.add(task);
            }
            tasks.removeAll(completedTasks);
        });
    }

    private static class Task {
        int ticksRemaining;
        Runnable action;

        Task(int ticksRemaining, Runnable action) {
            this.ticksRemaining = ticksRemaining;
            this.action = action;
        }
    }
}

